pro litbidim

;+
; NAME
; litbidim
;
; PURPOSE
; Plots a data file from ground calibrations (observation of a
;	black body - Glowbar - at about 120 Celsius degrees).
;
; CALLING SEQUENCE:
;	litbidim
;
; COMMENTS:
;	The instrument lies on a moving platform. The viewing direction 
;	changes from spectrum to spectrum and scans the source. The source is
;	mapped only by the platform movement, the entrance mirror of the 
;	instrument itself remains in the rest position. 
;	128 spectral images of the source are reconstituted from these spectra, 
;	and plotted. The images would superimpose if channels were perfectly 
;	coregistered. The shift between channels of same parity is a measure of 
;	misregistration effects. Between odd and even channels, it is related
;	to the difference in viewing directions (about 23' average).
;	Registration coefficients (file 'decal2.dat') are partly derived from
;	this experience.
;	Spectral images are displays in sequence (channels 1 to 128), by lines 
;	of 8 channels (alternatively odd and even). Short and long wavelengths
;	are separated (respectively on top and bottom of the window).
; i : angular position of the platform in the vertical plane (elevation)
; j : angular position of the platform in the horizontal plane (azimut)
; tab(i,j,*) : spectra acquired for this position of the instrument
; vertical angle (in degrees): -0.50 to +0.15, step 0.05 (i=1 to 14)
; horizontal angle (in degrees): +0.95 to +1.35, step 0.05 (j=1 to 9)
; Spectra are averaged and dark current is subtracted.
;
; MODIFICATION HISTORY:
;	Stephane Erard, september 1995
;--------------------------------------------------


bid=fltarr(128)
tab=fltarr(14,9,128)
ima=fltarr(14,9)

IF (!version.release gt 3.6) THEN BEGIN
 CASE !version.os_family OF
  'vms' :dirdata= !ISM_dir+"EDT_DATA.GROUND]"
  'unix' :dirdata=!ISM_dir+"EDT_DATA/GROUND/"
  'MacOS' :dirdata=!ISM_dir+"EDT_DATA:GROUND:"
  ELSE: dirdata=""     ; assumes data in the same directory
 ENDCASE
ENDIF ELSE dirdata=""     ; assumes data in the same directory

openr, ERROR=error, unit, /get_lun, dirdata+"BIDIM.DAT"

while not eof(unit) do begin
 readf,unit,i,j
 readf,unit, bid
 tab(i-1,j-1,*)=bid
endwhile
free_lun, unit

window,/free, xs=14*8*4,ys=9*17*4
loadct, 11

for canal=0,63 do begin
 ima=tab(*,*,canal)
 ima2=rebin(ima,14*4,9*4)
 tvscl, ima2, canal
endfor
for canal=64,127 do begin
 ima=tab(*,*,canal)
 ima2=rebin(ima,14*4,9*4)
 tvscl, ima2, canal+8
endfor

end
