FUNCTION ISM_ses2, fen, error

;+
; NAME
; ISM_ses2

;	PURPOSE
; Defines parameters for ISM extra sessions (calibrations and so on). 
; Does not attempt to read the information from the PDS labels.

; CALLING SEQUENCE:
;	Result = ISM_ses2 (fen, Error)

; INPUT PARAMETERS:
;	fen: string, root of the data file name

; OUTPUT PARAMETERS:
;	Param: structure containing session parameters:
;	{parameter, lim: IntArr(4)           ; Limits in latitude and longitude
;           , nLines: 0, nSamples: 0   ; Number of lines and samples
;           , nElt: 0                  ; Number of calibrated spectra
;           , DataFile: ''             ; Name of the data file (even channels)
;           , CoorFile: ''             ; Name of the coordinate file
;           , ID: ''                   ; Session acronym  
;           , Region: ''               ; Explicit region name  
;           , date: ''                 ; Date of observation
;	          , IntegTime: 0.            ; Integration time in seconds
;           , Temp: 0.                 ; Average Focal plane temperature (Celsius)
;           , Gain:0}                  ; Analogic gain
;
;	Error: Error flag
;
; MODIFICATION HISTORY:
;	Stephane Erard, june 2001
;-
;******************************************************************************



param = {parameters, Lim: IntArr(4), nLines: 0, nSamples: 0, nElt: 0, $ 
DataFile: '', CoorFile: '', ID: '', Region: '', Date: '', IntegTime: 0.,$
Temp: 0., Gain: 0}

si=size(fen)
if si(si(0)+1) ne 7 then BEGIN 
Message, /CONTINUE, 'Uncorrect session ID: ' + fen
error = 1
RETURN, 0
ENDIF

fen=STRUPCASE(fen)
Param.ID=fen
Param.DataFile=fen+'EVEN.CAL'     ; Default is even channels, calibrated data
Param.CoorFile=fen+'_COOR.DAT'
ISMdef                            ; Defines ISM root directory
;while strlen(fen) LT 4 do fen=fen+' '

 Param.lim=[0.,0.,0.,0.]
CASE 1 of 
fen EQ 'SPIN': BEGIN
 Param.Region='Spinning session'
 Param.nLines=121
 Param.nSamples=25
 Param.nElt=3025
 Param.date='22/02/1989'
 Param.IntegTime=0.5
 Param.Temp=-72.3
 Param.Gain=2
END
fen EQ 'CRU1': BEGIN
 Param.Region='Cruise'
 Param.nLines=9
 Param.nSamples=1
 Param.nElt=9
 Param.date='01/1989'
 Param.IntegTime=0.125
 Param.Temp=-72.0
 Param.Gain=1
END
fen EQ 'CRU2': BEGIN
 Param.Region='Cruise'
 Param.nLines=7
 Param.nSamples=49
 Param.nElt=343
 Param.date='01/1989'
 Param.IntegTime=1.0
 Param.Temp=-72.0
 Param.Gain=1
END
strmid(fen,0, 3) EQ 'LIM': BEGIN
 Param.Region='Mars limb'
 Param.nLines=10
 Param.nSamples=1
 Param.nElt=10
; Param.date='21/02/1989'
; Param.IntegTime=0.5
; Param.Temp=-71.2
; Param.Gain=2
 CASE strmid(fen, 3,1) of 
 1: BEGIN
   Param.nLines=21
   Param.nSamples=8
   Param.nElt=168
   end
 6: BEGIN
   Param.nLines=1
   Param.nElt=1
   end
 7: BEGIN
   Param.nLines=18
   Param.nElt=18
   end
 8: BEGIN
   Param.nLines=23
   Param.nElt=23
   end
 9: BEGIN
   Param.nLines=24
   Param.nElt=24
   end
  ELSE: error = 0
  ENDCASE
END
strmid(fen,0, 2) EQ 'PH': BEGIN
 Param.Region='Phobos extra'
 Param.nLines=10
 Param.nSamples=1
 Param.nElt=10
; Param.date='21/02/1989'
 Param.IntegTime=1.
; Param.Temp=-71.2
; Param.Gain=2
END
strmid(fen,0, 2) EQ 'CA': BEGIN
 Param.Region='Flight calibration'
 Param.nLines=80
 Param.nSamples=1
 Param.nElt=80
; Param.date='27/02/1989'
 Param.IntegTime=1.0
; Param.Temp=-75.8
; Param.Gain=2
 CASE strmid(fen, 2,2) of 
 12: BEGIN
   Param.nLines=76
   Param.nElt=76
   end
 18: BEGIN
   Param.nLines=75
   Param.nElt=75
   end
 19: BEGIN
   Param.nLines=64
   Param.nElt=64
   end
  ELSE: error = 0
  ENDCASE
 END
strmid(fen,0, 3) EQ 'LIM' and strmid(fen, 3,1) GT 9: BEGIN
 Message, /CONTINUE, 'Unknown session ID: ' + fen
 error = 1 
 RETURN, 0
END
strmid(fen,0, 2) EQ 'CA' and strmid(fen, 2,2) GT 30: BEGIN
 Message, /CONTINUE, 'Unknown session ID: ' + fen
 error = 1 
 RETURN, 0
END
strmid(fen,0, 2) EQ 'PH' and strmid(fen, 2,1) GT 6: BEGIN
 Message, /CONTINUE, 'Unknown session ID: ' + fen
 error = 1 
 RETURN, 0
END
ELSE: BEGIN
Message, /CONTINUE, 'Unknown session ID: ' + fen
error = 1
RETURN, 0
ENDELSE
ENDCASE

error = 0
RETURN, param
END
