pro ISM_REP, lam, niv, error, ODD= odd

;--------------------------------------------------

;+
; NAME
; ISM_REP
;
; PURPOSE
; Reads ISM spectral response for even or odd channels 
; (files reponses.dat or reponsesi.dat). The values were measured 
; with a monochromator with specral sampling ~12 times ISM spectral sampling.
; These values can be used to convolve any spectrum to ISM resolution, and can 
; be plotted properly with affrep.pro.
;
; CALLING SEQUENCE:
;	ISM_REP, lam, niv, error, [/ODD])
;
; OUTPUT PARAMETER:
; lam(64,12)	For each ISM channel, 12 wavelengths of measurement
; niv(64,12)	For each ISM channel, 12 measured relative intensities
;	Error:   Error flag
;
; KEYWORD PARAMETER:
; /ODD     Plots odd channels (Use file reponsesI.dat)
;
; MODIFICATION HISTORY:
;	Stephane Erard, may 2001
;
;--------------------------------------------------



tab1=fltarr(4,768)
lam=fltarr(64,12)
niv=fltarr(64,12)

datat='CALIB'
noms='REPONSES.DAT'
tit1 = 'Even channels'
IF Keyword_Set(odd) THEN begin
  noms='REPONSESI.DAT'
  tit1 = 'Odd channels'
endif
IF (!version.release gt 3.6) THEN BEGIN
 CASE !version.os_family OF
  'vms' :dirdata= !ISM_dir+datat+"]"
  'unix' :dirdata=!ISM_dir+datat+"/"
  'MacOS' :dirdata=!ISM_dir+datat+":"
  ELSE: dirdata=""     ; assumes data in the same directory
 ENDCASE
ENDIF ELSE dirdata=""     ; assumes data in the same directory

openr, ERROR=error, unit, /get_lun, dirdata+noms
readf,unit, tab1
free_lun, unit
loadct, 12

for i=0,63 do begin
 lam(i, 0:11)=tab1(3,i*12+0:i*12+11)
 niv(i, 0:11)=tab1(2,i*12+0:i*12+11)
endfor

end
