PRO ISM_pho, canal0, ODD=ODD, PS=ps, REAL=real, ALBEDO= albedo, ANGLE=angle

;+
; NAME
; ISM_pho

; PURPOSE
; Reads ISM calibrated Phobos data file and maps a complete session using screen
; coordinates (Satellite projection).

; CALLING SEQUENCE:
;	ISM_pho, canal0

; INPUT PARAMETERS:
; canal0: channel to map (from 1 to 64, number in the even or odd array).

; OUTPUT PARAMETERS:
; none

; KEYWORD PARAMETERS:
; ODD: displays odd channels (default is even channels)
; PS: writes a PostScript file with the map
; ALBEDO: Performs a Minnaert correction to computes and displays albedo.
; ANGLE: permits to plot phase, emergence or incidence
; REAL: uses real pixels coordinates. Default is making pixels adjacent 
; by recomputing pixels limits.

; SUBROUTINES:
; Make calls to ISM_sess, ISM_lam, ISM_data, and ISM_coor

; MODIFICATION HISTORY:
;	Stephane Erard, july 1998

;-
;******************************************************************************


fen='PHO'
param=ISM_sess(fen, error)     ; read session parameters
IF (error NE 0) THEN RETURN
if n_params() eq 0 then begin 
 print, 'Please give the number of the channel to map (1-64)'
 read, canal0
endif
fen=STRUPCASE(fen)
canal = canal0 - 1	; IDL indices

if keyword_set(ps) then begin
 devori=!D.name
 set_plot,'ps'
 device,filename='ISM_pho.ps',/landscape,/helvetica, bit=8
 oldfont=!P.font
 !P.font=0
endif


IF Keyword_Set (odd) THEN BEGIN
 Param.DataFile= Param.ID+'ODD.CAL'
 lam=ISM_lam(error,/ODD)
ENDIF ELSE lam=ISM_lam(error)             ; read wavelength file
IF (error NE 0) THEN RETURN


tab=ISM_data(param, error)     ; read calibrated data
IF (error NE 0) THEN RETURN
param.coorFile='PHO_SCRN.DAT'
IF Keyword_Set (real) THEN param.coorFile='PHO_SCOR.DAT'
coord=ISM_coor(param,error)    ; read coordinates file
IF (error NE 0) THEN RETURN
ima=intarr(Param.nLines,Param.nSamples,/nozero)


if (!D.window eq -1) and ((!D.FLAGS and 256) ne 0) then window
k = 0.55     ; Minnaert's exponent for Phobos
tit1='Reflectance'
if keyword_set(albedo) then tit1= 'Albedo'
titre=Param.region+'!C'+tit1+' map '+string(lam(canal), $
  format='(F8.3)')+' micron'  
ind = where(coord.mirror ne 0)    ; pixels with data
if N_elements(angle) eq 0 then angle=" "
angle = strlowcase(angle)

Case ANGLE of 
'emergence': begin
  maxi=max(Coord(ind).emergence, min=mini)
  titre=Param.region+'!C'+'Map of emergence angles'
  if not(keyword_set(silent)) then $
    print, 'Min/max emergence angles (degrees):', [mini, maxi]/100.
  ima=bytscl(Coord.emergence, min=mini, max=maxi, top = (!D.N_Colors - 2))
  end
'incidence': begin
  maxi=max(Coord(ind).incidence, min=mini)
  titre=Param.region+'!C'+'Map of incidence angles'
  if not(keyword_set(silent)) then $
    print, 'Min/max incidence angles (degrees):', [mini, maxi]/100.
  ima=bytscl(Coord.incidence, min=mini, max=maxi, top = (!D.N_Colors - 2))
  end
'phase': begin
  maxi=max(Coord(ind).phase, min=mini)
  titre=Param.region+'!C'+'Map of phase angles'
  if not(keyword_set(silent)) then $
    print, 'Min/max phase angles (degrees):',[mini, maxi]/100.
  ima=bytscl(Coord.phase, min=mini, max=maxi, top = (!D.N_Colors - 2))
  end 
else: begin
  par = 'even'
  if keyword_set(odd) then par ='odd'
  print, format='("Map of '+par+' channel ",I0," (Wavelength = ",F8.4," micron)")'$
    ,canal+1,lam(canal)
  if keyword_set(albedo) then begin
   print, 'Map of geometric albedo tentatively computed with Minnaert''s model (k = 0.7)' 
   Ima = float(Tab.spec(canal))
   Coord.incidence=coord.incidence < 8500
   ima = ima*cos(Coord.emergence*(!dtor/100.))^(1.-k)/cos(Coord.incidence*(!dtor/100.))^k
   maxi = max(ima(ind), min=mini)
   ima = bytscl(ima, min=mini, max=maxi, top = (!D.N_Colors - 2))
  endif else begin
   maxi=max(Tab(ind).spec(canal), min=mini)
   ima=bytscl(Tab.spec(canal), min=mini, max=maxi, top = (!D.N_Colors - 2))
  endelse
  if not(keyword_set(silent)) then $
    print, 'Min/max reflectance:', [mini, maxi] /32768.*.5
  end
endcase

plot, /nodata, [-250,-150],[-35,35], title=titre, position=[0.1,0.1,.9,.9],$
 xtickname=replicate(' ',10), ytickname=replicate(' ',5)

nbf=0
lon=(lat=fltarr(4))

for j=0,Param.nLines*Param.nSamples-1 do begin
if (coord(j).mirror gt 0) then begin
 nbf=nbf+1
 for i=0,3 do begin
  lon(i)=-coord(j).coord(2*i)/100.
  lat(i)=coord(j).coord(2*i+1)/100.
 endfor 
; col=coord(j).emergence/100.*ran     ; map of emergence angle
 col = ima(j)
 if max(lon) ne 0 and coord(j).emergence gt 0 then polyfill,lon,lat,color=col
endif else print, j
endfor
print, 'nb of spectra:', nbf

if keyword_set(ps) then begin
 device, /close
 set_plot,devori
 !P.font=oldfont
endif
;canal = canal + 1	; restore input value

END
