FUNCTION ISM_lam, error, ODD=ODD

;+
; NAME
; ISM_lam

; PURPOSE
; Reads ISM channel wavelengths, 64 even or odd channels.

; CALLING SEQUENCE:
;	lam = ISM_lam(error, [/ODD])

; OUTPUT PARAMETERS:
;	Tab:     Array of 64 channel wavelengths, even (default) or odd.
;	Error:   Error flag

; KEYWORD PARAMETERS:
; /ODD     Return wavelengths for odd channels.

; MODIFICATION HISTORY:
;	Stephane Erard, july 1998
;-
;******************************************************************************



lam=fltarr(3,128,/nozero)
lam11=(lam20=(lam21=(lam10=fltarr(32,/Nozero))))

IF (!version.release gt 3.6) THEN BEGIN
 CASE !version.os_family OF
  'vms' :dircal= !ISM_dir+"CALIB]"
  'unix' :dircal=!ISM_dir+"CALIB/"
  'MacOS' :dircal=!ISM_dir+"CALIB:"
 ELSE: dircal=""     ; assumes data in the same directory
 ENDCASE
ENDIF ELSE dircal=""     ; assumes data in the same directory


openr, ERROR=error, unit, /get_lun, dircal+"LAMBDA.DAT"
IF (error NE 0) THEN BEGIN
Message, /CONTINUE, !Err_String
RETURN, 0
ENDIF 
readf, unit, lam
free_lun, unit

for i=0,31 do begin
 lam20(i)=lam(2,i*2+1)	; even channels
 lam10(i)=lam(2,i*2+64)
 lam21(i)=lam(2,i*2)	; odd channels
 lam11(i)=lam(2,i*2+65)
endfor

error = 0
IF Keyword_Set(odd) THEN RETURN, [Lam21,Lam11] $
 ELSE RETURN, [Lam20, Lam10]
END 
