FUNCTION ISM_data, Param, Error

;+
; NAME
; ISM_data

; PURPOSE
; Reads ISM calibrated data files, even or odd channels.
; On computers using big-endian encoding, change byteorder after reading.

; CALLING SEQUENCE:
;	ISM_data(Param, Error)

; INPUT PARAMETERS:
;	Param: structure containing session parameters, as defined by ISM_sess
; (including file name, possibly modified to read raw data or odd channels).


;OUTPUT PARAMETERS:
;	Tab:     Array of structure containing data as written by Etalonne.for
; {Image_Cube, hour: 0, minute: 0, second: 0, tic: 0 ; timing information
;            , line: 0, sample: 0                    ; line and sample numbers
;            , temp: 0           ; focal plane temperature, Celsius
;            , mirror: 0         ; Mirror position (coded)
;            , spec: IntArr(64)} ; spectral measurements (64 channels)

;	Error: Error flag

; LIMITATIONS: 
; To be done in the calling routine (not useful for raw data) _on floats_
;  Tab.temp= Tab.temp/100.      ; decode temperature
;  Tab.spec= Tab.spec/32768.*.5 ; decode reflectance

; MODIFICATION HISTORY:
;	Stephane Erard, july 1998
;-
;******************************************************************************



noms=STRUPCASE(Param.DataFile)
numspec=Param.nLines * Param.nSamples
tab= Replicate ({Image_Cube, hour: 0, minute: 0, second: 0, tic: 0, $ 
line: 0, sample: 0, temp: 0, mirror: 0, spec: IntArr(64)}, $ 
param.nSamples, param.nLines)

subdir='MARS'
IF (strupcase(Param.ID) eq 'PHO') THEN subdir='PHOBOS'
datat='CAL'
IF (strupcase(strmid(Param.DataFile,strlen(Param.DataFile)-3,3)) eq 'EDT') THEN datat='EDT'
IF datat EQ 'EDT' and Param.lim(0) eq 0. and Param.lim(2) eq 0. then subdir='OTHER'
IF subdir EQ 'OTHER' and (strmid(strupcase(Param.ID),0,2) eq 'CA') then subdir='CALIB'


IF (!version.release gt 3.6) THEN BEGIN
 CASE !version.os_family OF
  'vms' :dirdata= !ISM_dir+datat+"_DATA."+subdir+"]"
  'unix' :dirdata=!ISM_dir+datat+"_DATA/"+subdir+"/"
  'MacOS' :dirdata=!ISM_dir+datat+"_DATA:"+subdir+":"
  ELSE: dirdata=""     ; assumes data in the same directory
 ENDCASE
ENDIF ELSE dirdata=""     ; assumes data in the same directory


openR, ERROR=error, unit, /get_lun, dirdata+noms
IF (error NE 0) THEN BEGIN
Message, /CONTINUE, !Err_String
RETURN, 0
ENDIF 

readu, unit, tab
free_lun, unit

; Transform to big-endian encoding
; In releases 3.5 and 3.6, !version.os_family is not defined
IF (!version.release gt 3.6) THEN BEGIN
 IF ((!version.os_family eq 'unix' and !version.arch ne 'alpha') $
 or !version.os eq 'MacOS') THEN byteorder, tab 
ENDIF ELSE IF (!version.os eq 'MacOS') THEN byteorder, tab

error = 0
RETURN, Tab
END

