FUNCTION ISM_coor, Param, Error

;+
; NAME
; ISM_coor

;	PURPOSE
; Reads ISM coordinates files.
; On computers using big-endian encoding, change byteorder after reading.

; CALLING SEQUENCE:
;	ISM_coor(Param, Error)

; INPUT PARAMETERS:
;	Param: structure containing session parameters, as defined by ISM_sess
; (including file name, possibly modified to read raw data or odd channels).


;OUTPUT PARAMETERS:
;	Coord:     Array of structure containing data as written by Etalonne.for
; {Coordinate, line: 0, sample: 0     ; grid information
;            , coord: intarr(8)       ; longitude and latitude of pixels corners
;            , incidence: 0           ; incidence angle
;            , emergence: 0           ; emergence angle
;            , phase: 0               ; phase angle
;            , mirror: 0}             ; mirror position (coded, O if no data)

;	Error: Error flag

; LIMITATIONS:
; Left to be done in the calling routine _on floats_:
;  coord.incidence= coord.incidence/100.      ; decode angles
;  coord.emergence= coord.emergence/100.      ; decode angles
;  coord.phase= coord.phase/100.              ; decode angles
;  coord.coord= coord.coord/100.       ; decode coordinates

; MODIFICATION HISTORY:
;	Stephane Erard, july 1998
;-
;******************************************************************************


noms=STRUPCASE(Param.CoorFile)
numspec=Param.nLines * Param.nSamples
coord= Replicate ({Coordinate, line: 0, sample: 0, coord: intarr(8), $ 
incidence: 0, emergence: 0, phase: 0, mirror: 0}, param.nSamples, param.nLines)


IF (!version.release gt 3.6) THEN BEGIN
 CASE !version.os_family OF
  'vms' :dircoord= !ISM_dir+"GEOMETRY]"
  'unix' :dircoord=!ISM_dir+"GEOMETRY/"
  'MacOS' :dircoord=!ISM_dir+"GEOMETRY:"
 ELSE: dircoord=""     ; assumes coordinates in the same directory
 ENDCASE
ENDIF ELSE dircoord=""     ; assumes coordinates in the same directory

openR, ERROR=error, unit, /get_lun, dircoord+noms
IF (error NE 0) THEN BEGIN
Message, /CONTINUE, !Err_String
RETURN, 0
ENDIF 

readu, unit, coord
free_lun, unit

; Transform to big-endian encoding
; In releases 3.5 and 3.6, !version.os_family is not defined
IF (!version.release gt 3.6) THEN BEGIN
 IF ((!version.os_family eq 'unix' and !version.arch ne 'alpha') $
 or !version.os eq 'MacOS') THEN byteorder, coord 
ENDIF ELSE IF (!version.os eq 'MacOS') THEN byteorder, coord

error = 0
RETURN, coord
END

