	program EtalPho

c   ===================================================================
c		Stphane ERARD, juillet 95


c	Writes the calibrated data files for the Phobos session, with final 
c	 recalibration.

c	Reads the data from the decompressed/resampled data files 
c	 phoeven/odd.res written by Convert.for (the name of the input 
c	 directory is in ch2).

c	Output = unformatted, 64 channels for even and odd devices separately,  
c	 in ascending order (increasing wavelengths).
c	 The first sample of each line is discarted, so the files are only
c	 25 samples per line. The resulting size of the image is 24 x 25.

c	Intensities from 0.0 to 0.5 are coded as 16-bits signed integers, 
c	 from 0 to 32767. This preserves signal-to-noise and doesn't yield
c	 digital saturation.
c	The calibration of odd channels is not optimized, and can be very 
c	 poor in some areas (see 'DocISM.asc').
c	Processing is similar to that of Mars sessions, with a DC file taken 
c	 from March 21st session, no registration correction (this is already 
c	 performed in the input file by Corpho.for), and a different set of 
c	 recalibration coefficients (recalibration offsets for Mars account 
c	 for stray light, which is assumed negligible here).


c	Additional data for each sample are similar to that in the input files,
c	 except temperature which is now coded in  Celsius (x 100).

c	Note that no attempt is made to coregistrate the two orders, so there 
c	 can remain a one/two-pixel wide difference between the two wavelength
c	 ranges (first and second sets of 32 channels).
c	 See docISM.asc for details about instrumental corrections.
c	 The coordinates for short wavelength-even channels are in 
c	 Pho_coor.dat and Pho_scrn.dat.

c   ===================================================================

	implicit none

	integer*2 	tmois,
     &			i,id,imo,nspe,imois,ij,
     &			k,j,nbf,int,iph,ips,ipm,ipd,
     &			ih,im,is,jh,jm,js,kh,km,ks,gain0,jtic,
     &			x,y,xold,l,ymax,
     &			buff1(72),buff(72),long

	real*4		gain(128),lam(129),decal(128),mir(0:300,27),
     &			fond1(128),atm(128),tdet(0:300,27),Told,
     &			gain2(128),temps(0:300,27),Tdeg,
     &			axi,exi,ainc,gomeg,pomeg,alo,ala,ax,
     &			sdf,sff,sk,ss,w2,w3,
     &			spec(128),wal(129),matrice(0:300,27,128),
     &			mtf(128),gain1(128),lamb(139),coefTt(128),
     &			corT(128),b1(128),b2(128),b3(128),m1d2(128),
     &			sol(128),alphap,alphai,raym,
     &			gain3(128),gain3b(128),durm(11),dum,m3d2(128),
     &			coefT(128),coef(128)

			
	character*55 	nomfic,nom,ch2,ch
	character*25	nomf
	character*15	mtfst,atmst,fic
	character*3	ch1

	data gain/128*1./
	data gain1/128*1./
	data gain2/128*1.989/
	data gain3b/128*1.0/
	data spec/128*0./
	data fond1/128*0./
	data durm/31.,28.,31.,30.,31.,30.,31.,31.,30.,31.,30./



558	continue
	imois=3
	ij=25
	ch='$1$DUA1:[PCCOMMON.BASEISM.CALIB]'
	ch2 ='$1$DUA1:[PCCOMMON.BASEISM.EDT_DATA.PHOBOS]'
	open(unit=4,file=ch//'orbit.dat',status='old',shared)
	do 5120 i=1,12
	  read(4,5200)id,imo,ih,im,is,jh,jm,js,nom,nomf,nspe,gain0
	  read(4,5201)axi,exi,ainc,gomeg,pomeg,iph,ipm,ips,ipd,alo,ala
	  if(imois.eq.imo.and.ij.eq.id)goto 5121
5120	continue
5200	format(1x,2i3,2x,6i3,1x,a13,a13,i5,i2)
5201	format(1x,f8.2,f9.6,f9.4,2f8.3,4i3,2f4.1)
5121	close(unit=4)
	write(6,5200)id,imo,ih,im,is,jh,jm,js,nom,nomf,nspe,gain0
	write(6,5201)axi,exi,ainc,gomeg,pomeg,iph,ipm,ips,ipd,alo,ala



99	format(a13)
	nomfic=ch//nom(1:9)//'dat'
	do i=49,64	! Gain sur les barrettes
	  gain(i)=2.	!Correction grossiere(utilisee sur les fonds)
	  gain1(i)=.995 ! Gain1 reel
	  gain2(i)=1.980 !Correction a gain(i)*gain2 reel
	  gain3b(i)=0.995 ! - -        - -    *gain1 reel
	enddo
	do i=113,128
	  gain(i)=2.
	  gain1(i)=.995
	  gain2(i)=1.980
	  gain3b(i)=0.995
	enddo

	do i=0,300
	do j=1,27
	 matrice(i,j,8)=0.
	enddo
	enddo

	mtfst='alph0.spe'
c	atmst='logatm.spe'
	open(unit=2,file=ch//'sourvol.det',status='old')
	open(unit=9,file=ch//mtfst,status='old')
	open(unit=10,file=ch//'specsol.the',status='old')
	open(unit=11,file=ch//'beta.spe',status='old')
c	open(unit=12,file=ch//atmst,status='old')
	open(13,file=ch//'gain3.vo2',status='old')
	open(14,file=ch//'gamm0.spe',status='old')
	open(15,file=ch//'decal2.dat',status='old')
	do j=1,128
	 read(2,130)i,b1(i),b2(i),b3(i)
	 read(10,21)i,sol(i),dum
	 read(11,21)i,m1d2(i),dum
c	 read(12,21)i,atm(i),dum
	 read(13,21)i,gain3(i),dum
	 read(14,21)i,m3d2(i),dum
	 read(15,21)i,decal(i),dum	
	 gain3(i)=gain3(i)*gain3b(i)
	 read(9,21)i,mtf(i),dum
	enddo
	close(2)
	close(9)
	close(10)
	close(11)
c	close(12)
	close(13)
	close(14)
	close(15)

	open(3,file='coef.pho',status='old')
	open(4,file=ch//'coef.dec',status='old')
	do j=1,128
	 read(3,21)i,coef(j),dum
	 read(4,21)i,coefT(j),lam(i)	!To be read last : contains the
	enddo				! correct wavelengths.
	close(1)
	close(3)
	close(4)

	nomf='/'
	type*,nom

	if(nom(1:9).eq.'phob2503.')then
		nomf='fond2103.dg3'
		gain0=3
		ih=16
		im=11
		is=51
		jh=16
		jm=17
		js=15
		ipd=25
		ymax=26
		xold=24
		raym=1.599
		fic='pho'
	endif
	if(fic.eq.' ')then
		write(6,*)'Pb date'
		goto558
	endif

	if(nomf.ne.'/')then
		open(unit=3,file=ch//nomf,status='old')
		do i=1,128
		 read(3,21)j,fond1(i),dum
		enddo
		close(3)
	else
		write(6,*)'Pb courant d''obscurit :',ch,nomf
		goto558
	endif
	
	long=36
	open(unit=8,file=ch2//fic//'even.res',form='unformatted',
     *	recl=long,access='direct',status='old')
	open(unit=9,file=ch2//fic//'odd.res',form='unformatted',
     * 	recl=long,access='direct',status='old')

	do x=1,xold
	 do y=2,ymax

	  nbf=nbf+1
	  read(8'nbf)buff		!even channels
	  read(9'nbf)buff1		!odd channels

	  jh=buff(1)
	  jm=buff(2)
	  js=buff(3)
	  jtic=buff(4)
	  temps(x,y)=jh*3600.+jm*60.+js+jtic*0.125	!Uses sexagesimal time
	  if (buff(5).ne.x)type*,'Lzard en x', x, y	! (for interpolations)
	  if (buff(6).ne.y)type*,'Lzard en y', x, y
	  tdet(x,y)=buff(7)
	  mir(x,y)=buff(8)

 	  do i=1,32
	   matrice(x,y,i*2)=buff(i+8)
	   matrice(x,y,i*2-1)=buff1(i+8)
	  enddo
	  do i=1,32
	   matrice(x,y,i*2+63)=buff(i+40)
	   matrice(x,y,i*2+64)=buff1(i+40)
	  enddo

	 enddo
	enddo

298	close(8)
	close(9)
	if(nbf.eq.0) type*, 'Timing problem...'

	type*,'End in line',xold,', sample',ymax
	type*,'Nb of spectra read:',nbf
	Type*,'Correcting the data...'


c	Un clair... puis la nuit ! - Fugitive beaut
c	Dont le regard m'a fait soudainement renatre,
c	Ne te verrai-je plus que dans l'ternit ?

c	Ailleurs, bien loin d'ici ! trop tard ! jamais peut-tre !
c	Car j'ignore o tu fuis, tu ne sais o je vais,
c	O toi que j'eusse aime,  toi qui le savais !

c	Charles Baudelaire
c     [so-called "special" characters are coded in Macintosh format]


c	-----  Open output files  -----


	ch1='cal'

	open(unit=2,file=fic//'even.'//ch1,form='unformatted',
     *	recl=long,access='direct',status='new')	
	open(unit=1,file=fic//'odd.'//ch1,form='unformatted',
     * 	recl=long,access='direct',status='new')	
 
c	****	Instrumental corrections ****

	nbf=0
	Told=0.

	do x=1,xold
	 do l=1,128	! set first sample of each line to 0 (integrated 
	   matrice(x,1,l)=0.	! while the mirror is moving)
	 enddo
	 do y=2,ymax
	  nbf=nbf+1

 	  tdeg=49.96721-4.066708e-2*tdet(x,y)	!T en  Celsius
	  if(Tdeg.ne.Told)then
	    do i=1,128
	      corT(i)=(b3(i)*tdeg+b2(i))*tdeg+b1(i)
	    enddo
	    Told=Tdeg
	  endif

c	----- Corrects from background, gain, temperature -----

		 do i=1,128
		  spec(i)=(matrice(x,y,i)/gain(i)-fond1(i))/gain3(i)/cort(i)
		 enddo


c	----- Subtraction of additive components in the short wavelengths -----

	do i=63,128	! First order correction
	  wal(i)=spec(i)/mtf(i)
	end do
	lam(129)=2.*lam(128)-lam(127)
	wal(129)=2.*wal(127)-wal(125)
	do i=1,64
	    w2=2*lam(i)
	    do j=65+mod(i,2),128+mod(i,2),2
	      if(lam(j).gt.w2)goto 303
	    end do
303	    w3=((w2-lam(j-2))*wal(j)+(lam(j)-w2)*wal(j-2))/
     &		(lam(j)-lam(j-2))
	    if(j.eq.65) w3=((w2-lam(64))*wal(j)+(lam(j)-w2)*wal(64))/
     &		(lam(j)-lam(64))
	    if(j.eq.66) w3=((w2-lam(63))*wal(j)+(lam(j)-w2)*wal(63))/
     &		(lam(j)-lam(63))
	    spec(i)=spec(i)-m1d2(i)*w3
	end do

	do i=1,64	! Third order correction
	  wal(i+10)=spec(i)/mtf(i)
	  lamb(i+10)=lam(i)
	enddo
	lamb(10)=2.*lamb(11)-lamb(12)
	lamb(9)=2.*lamb(10)-lamb(12)
	wal(10)=2.*wal(12)-wal(14)
	wal(9)=2.*wal(11)-wal(13)
	do i=31,64
	    w2=2*lam(i)/3
	    do j=2-mod(i,2),64-mod(i,2),2
	      if(lamb(j+10).gt.w2)goto 304
	    end do
304	    w3=((w2-lamb(j-2+10))*wal(j+10)+(lamb(j+10)-w2)*wal(j-2+10))/
     &           (lamb(j+10)-lamb(j-2+10))
	    spec(i)=spec(i)-m3d2(i)*w3
	enddo


c	----- Division by transfer function and scaled Sun -----

		!Results = radiance factors

		do i=1,128	!Correction FT, distance au Soleil
		  spec(i)=spec(i)/mtf(i)*(raym**2)/sol(i) 
		enddo


c	-----  recalibration relative to meteoritical analog  -----

		do i=1,128
		   spec(i)=(spec(i))/coef(i)	! No recal offset
		enddo

		do i=1,128
		   if(spec(i).gt.0.5)spec(i) = 0.5	!In case of saturation.
		   if(spec(i).lt.-0.5)spec(i) = 0.    !(this may serve in the
		enddo				     !  dark sky)


c	----- Digitize the data and store the final array -----

174	jh=temps(x,y)/3600
	jm=amod(temps(x,y),3600.)/60
	js=amod(temps(x,y),60.)
	jtic=(temps(x,y)-int(temps(x,y)))*8
	buff(1)=jh
	buff(2)=jm
	buff(3)=js
	buff(4)=jtic
	buff(5)=x
	buff(6)=y
	buff(7)=tdeg*100
	buff(8)=mir(x,y)

	buff1(1)=jh
	buff1(2)=jm
	buff1(3)=js
	buff1(4)=jtic
	buff1(5)=x
	buff1(6)=y
	buff1(7)=tdeg*100
	buff1(8)=mir(x,y)

 	  do i=1,32
	   buff(i+8)=(spec(2*i)/0.5)*32767
	   buff1(i+8)=(spec(2*i-1)/0.5)*32767
	  enddo
	  do i=1,32
	   buff(i+40)=(spec(2*i+63)/0.5)*32767
	   buff1(i+40)=(spec(2*i+64)/0.5)*32767
	  enddo

	write(2'nbf)buff	!even channels
	write(1'nbf)buff1	!odd channels


c	----- End of main loop -----

	 enddo
	enddo

	type*,'nb of registered spectra',nbf
	type*,'The image is',xold,'lines x',ymax-1,' samples'

	close(1)
	close(2)


5	format(A13)
6	format(1x,3(I6,2x))
7	format(1x,A13)
21	format(3x,I3,3x,E11.5,3x,F6.4)
130	format(1x,I3,3x,3(E14.6))
141	format(a3)
150 	format(2I4,F10.3,2x,32F7.4)

	end
