	program Etalonne

c   ===================================================================
c		Stphane ERARD, june 95


c	Writes the calibrated data files for Mars sessions, with final 
c	 recalibration. Interpolates missing spectra wherever it is possible.
c	 Atmosphere correction in option.

c	Reads the data from the decompressed data files xxxeven/odd.edt
c	 written by Convert.for (the name of the input directory is in ch2).

c	Output = unformatted, 64 channels for even and odd devices separately,  
c	 in ascending order (increasing wavelengths).
c	 The first sample of each line is discarted, so the files are only
c	 25 or 8 samples per line depending on the observation mode. The 
c	 resulting size of the image is xold x (ymax -1), with the values
c	 initialized at the beginning of the program.

c	Intensities from 0.0 to 0.5 are coded as 16-bits signed integers, 
c	 from 0 to 32767. This preserves signal-to-noise and doesn't lead
c	 to digital saturation.
c	The calibration of odd channels is not optimized, and can be very 
c	 unsatisfying in some sessions.

c	Additional data for each sample are similar to that in the input files,
c	 except temperature which is now coded in  Celsius (x 100).

c	Note that no attempt is made to coregistrate the two orders, so there 
c	 can remain a one-pixel wide difference between the two orders 
c	 of a given file (first and second sets of 32 channels). 
c	 See docISM.asc for details about instrumental corrections.

c   ===================================================================

	implicit none

	integer*2 	tmois,
     &			i,id,imo,nspe,imois,ij,
     &			k,j,nbf,int,iph,ips,ipm,ipd,
     &			ih,im,is,jh,jm,js,kh,km,ks,gain0,jtic,
     &			Mirmin,x,y,xold,l,ymax,
     &			buff1(72),buff(72),long

	real*4		gain(128),lam(129),decal(128),mir(0:300,27),
     &			fond1(128),atm(128),tdet(0:300,27),Told,
     &			gain2(128),temps(0:300,27),Tdeg,
     &			axi,exi,ainc,gomeg,pomeg,alo,ala,ax,
     &			sdf,sff,sk,ss,fond2(128),w2,w3,
     &			spec(128),wal(129),matrice(0:300,27,128),
     &			mtf(128),gain1(128),lamb(139),coefTt(128),
     &			corT(128),b1(128),b2(128),b3(128),m1d2(128),
     &			sol(128),alphap,alphai,raym,
     &			gain3(128),gain3b(128),durm(11),dum,m3d2(128),
     &			coefT(128),off(128),coef(128)

			
	character*55 	nomfic,nom,ch2,ch
	character*25	nomf
	character*15	mtfst,atmst,fic
	character*3	ch1,rep2

	data gain/128*1./
	data gain1/128*1./
	data gain2/128*1.989/
	data gain3b/128*1.0/
	data spec/128*0./
	data fond1/128*0./
	data durm/31.,28.,31.,30.,31.,30.,31.,31.,30.,31.,30./



558	type *,' month :'
	accept *,imois
	type *,' day :'
	accept *,ij
	ch='$1$DUA1:[PCCOMMON.BASEISM.CALIB]'
	ch2 ='$1$DUA1:[PCCOMMON.BASEISM.EDT_DATA.MARS]'
	open(unit=4,file=ch//'orbit.dat',status='old',shared)
	do 5120 i=1,12
	  read(4,5200)id,imo,ih,im,is,jh,jm,js,nom,nomf,nspe,gain0
	  read(4,5201)axi,exi,ainc,gomeg,pomeg,iph,ipm,ips,ipd,alo,ala
	  if(imois.eq.imo.and.ij.eq.id)goto 5121
5120	continue
5200	format(1x,2i3,2x,6i3,1x,a13,a13,i5,i2)
5201	format(1x,f8.2,f9.6,f9.4,2f8.3,4i3,2f4.1)
5121	close(unit=4)
	write(6,5200)id,imo,ih,im,is,jh,jm,js,nom,nomf,nspe,gain0
	write(6,5201)axi,exi,ainc,gomeg,pomeg,iph,ipm,ips,ipd,alo,ala


	write(*,*)'Atmospheric correction (y/n)?'
	read(*,141)rep2

99	format(a13)
	nomfic=ch//nom(1:9)//'dat'
	do i=49,64	!Gains at the end of the arrays
	  gain(i)=2.	! First level correction, used on DC files
	  gain1(i)=.995 ! Correction to the previous value at gain 1
	  gain2(i)=1.980 !Correction to the previous value at gain 2
	  gain3b(i)=0.995 ! Correction to the previous value at gain 3
	enddo
	do i=113,128
	  gain(i)=2.
	  gain1(i)=.995
	  gain2(i)=1.980
	  gain3b(i)=0.995
	enddo

	do i=0,300
	do j=1,27
	 matrice(i,j,8)=0.
	enddo
	enddo

	mtfst='alph0.spe'
	atmst='logatm.spe'
	open(unit=2,file=ch//'sourvol.det',status='old')
	open(unit=9,file=ch//mtfst,status='old')
	open(unit=10,file=ch//'specsol.the',status='old')
	open(unit=11,file=ch//'beta.spe',status='old')
	open(unit=12,file=ch//atmst,status='old')
	open(13,file=ch//'gain3.vo2',status='old')
	open(14,file=ch//'gamm0.spe',status='old')
	open(15,file=ch//'decal2.dat',status='old')
	do j=1,128
	 read(2,130)i,b1(i),b2(i),b3(i)
	 read(10,21)i,sol(i),dum
	 read(11,21)i,m1d2(i),dum
	 read(12,21)i,atm(i),dum
	 read(13,21)i,gain3(i),dum
	 read(14,21)i,m3d2(i),dum
	 read(15,21)i,decal(i),dum	
	 gain3(i)=gain3(i)*gain3b(i)
	 read(9,21)i,mtf(i),dum
	enddo
	close(2)
	close(9)
	close(10)
	close(11)
	close(12)
	close(13)
	close(14)
	close(15)

	open(1,file=ch//'off7.spe',status='old')
	open(3,file=ch//'cof7.spe',status='old')
	open(4,file=ch//'coef.dec',status='old')
	do j=1,128
	 read(1,21)i,off(j),dum
	 read(3,21)i,coef(j),dum
	 read(4,21)i,coefT(j),lam(i)	!To be read last : contains the
	enddo				! correct wavelengths.
	close(1)
	close(3)
	close(4)

	nomf='/'
	type*,nom
	if(nom(1:9).eq.'mars0802.')then
		nomf='fond0802.dat'
		gain0=1
		ih=11
		im=05
		is=21
		jh=11
		jm=12
		js=08
		ymax=9
		xold=296
		mirmin=12
		raym=1.54679
		fic='pav'
	endif
	if(nom(1:9).eq.'mars1102.')then
		nomf='fond1102.dg2'
		gain0=2
		ih=16
		im=51
		is=43
		jh=16
		jm=58
		js=00
		ymax=9
		xold=274
		mirmin=233
		raym=1.55088
		fic='bib'
	endif
	if(nom(1:9).eq.'mars0103.')then
		nomf='fond0103.dg2'
		gain0=2
		ih=10
		im=45
		is=28
		jh=11
		jm=12
		js=36
		ymax=26
		xold=121
		mirmin=222
		raym=1.572447
		fic='syr'
	endif
	if(nom(1:9).eq.'mars1303.')then
		nomf='fond1303.dg2'
		gain0=2
		ih=11
		im=55
		is=25
		jh=12
		jm=15
		js=54
		ymax=26
		xold=91
		mirmin=156
		raym=1.587290
		fic='oly'
	endif
	if(nom(1:9).eq.'mars0703.')then
		nomf='fond0703.dat'
		gain0=1
		ih=3
		im=0
		is=47
		jh=3
		jm=27
		js=53
		ymax=26
		xold=121
		mirmin=2
		raym=1.579486
		fic='vmc'
	endif
	if(nom(1:9).eq.'mars2102.')then
		nomf='fond2102.dg2'
		gain0=2
		ih=10
		im=23
		is=3
		jh=10
		jm=44
		js=58
		ymax=26
		xold=98
		mirmin=228
		raym=1.562730
		fic='ara'
	endif
	if(nom(1:9).eq.'mars2702.')then
		nomf='fond2702.dg2'
		gain0=2
		ih=2
		im=41
		is=42
		jh=3
		jm=8
		js=51
		ymax=26
		xold=121
		mirmin=26
		raym=1.570081
		fic='dae'
	endif
	if(nom(1:9).eq.'mars1203.')then
		nomf='fond1403.dg2'
		gain0=2
		ih=3
		im=23
		is=42
		jh=3
		jm=50
		js=47
		ymax=26
		xold=121
		mirmin=2
		raym=1.585198
		fic='aur'
	endif
	if(nom(1:9).eq.'mars2603.')then
		nomf='fond2603.dg2'
		gain0=2
		ih=15
		im=03
		is=59
		jh=15
		jm=30
		js=52
		ymax=26
		xold=120
		mirmin=198
		raym=1.600988
		fic='heb'
	endif
	if(nom(1:9).eq.'mars2103.')then
		nomf='fond2103.dg3'
		gain0=3
		ih=12
		im=20
		is=36
		jh=12
		jm=47
		js=38
		ymax=26
		xold=120
		mirmin=162
		raym=1.595524
		fic='asc'
	endif
	if(nom(1:9).eq.'mars1403.')then
		nomf='fond1403.dg2'
		gain0=2
		ih=11
		im=50
		is=24
		jh=12
		jm=17
		js=25
		ymax=26
		xold=120
		mirmin=210
		raym=1.587860
		fic='gor'
	endif
	if(nom(1:9).eq.'phob2503.')then
		type*,'Mars files only '
		stop
	endif
	if(fic.eq.' ')then
		write(6,*)'Pb date'
		goto558
	endif
	if(nomf.ne.'/')then
		open(unit=3,file=ch//nomf,status='old')
		do i=1,128
		 read(3,21)j,fond1(i),dum
		enddo
		close(3)
	else
		write(6,*)'Pb courant d''obscurit :',ch,nomf
		goto558
	endif
	type *,' Distance Soleil-Mars :',raym

	nbf=0
	long=36

	open(unit=8,file=ch2//fic//'even.edt',form='unformatted',
     *	recl=long,access='direct',status='old')
	open(unit=9,file=ch2//fic//'odd.edt',form='unformatted',
     * 	recl=long,access='direct',status='old')

	do x=1,xold
	 do y=2,ymax

	  nbf=nbf+1
	  read(8'nbf)buff		!even channels
	  read(9'nbf)buff1		!odd channels

	  jh=buff(1)
	  jm=buff(2)
	  js=buff(3)
	  jtic=buff(4)
	  temps(x,y)=jh*3600.+jm*60.+js+jtic*0.125	!Uses sexagesimal time
	  if (buff(5).ne.x)type*,'Pb en x', x, y	! (for interpolations)
	  if (buff(6).ne.y)type*,'Pb en y', x, y
	  tdet(x,y)=buff(7)
	  mir(x,y)=buff(8)

 	  do i=1,32
	   matrice(x,y,i*2)=buff(i+8)
	   matrice(x,y,i*2-1)=buff1(i+8)
	  enddo
	  do i=1,32
	   matrice(x,y,i*2+63)=buff(i+40)
	   matrice(x,y,i*2+64)=buff1(i+40)
	  enddo

	 enddo
	enddo

298	close(8)
	close(9)
	if(nbf.eq.0) type*, 'Timing problem...'

	type*,'End in line',xold,', sample',ymax
	type*,'Nb of spectra read:',nbf
	Type*,'Correcting the data...'


c	Plutt la vie, plutt cette rosace sur ma tombe
c	La vie de la prsence, rien que de la prsence
c	O une voix dit "Es-tu l ?"
c	O une voix rpond "Es-tu l ?"
c	Je n'y suis gure hlas
c	Mais quand bien mme nous ferions le jeu de ce que nous faisons mourir
c	Plutt la vie

c Andr Breton
c     ["special" characters are coded in Macintosh format...]


c	-----  Open output files  -----


	ch1='cal'
	If (rep2(1:1).eq.'y'.or.rep2(1:1).eq.'Y') ch1='atm'

	open(unit=1,file=fic//'odd.'//ch1,form='unformatted',
     * 	recl=long,access='direct',status='new')	
	If (fic.eq.'asc'.and.ch1.eq.'cal') ch1='ca0'  ! Asraeus, even channels only
	open(unit=2,file=fic//'even.'//ch1,form='unformatted',
     *	recl=long,access='direct',status='new')	
 
c	****	Instrumental corrections ****

	nbf=0
	Told=0.

	do x=1,xold
	 do l=1,128	! set first sample of each line to 0 (integrated 
	   matrice(x,1,l)=0.	! while the mirror is moving)
	 enddo
	 do y=2,ymax
	  nbf=nbf+1

c	----- Corrects from misregistration and interpolates -----

	  id=1
	  if(matrice(x,y,8).gt.0.005)id=id*3
	  if(matrice(x-1,y+1,8).gt.0.005)id=id*5
	  if(matrice(x+1,y-1,8).gt.0.005)id=id*7

	if(id.eq.105)then	!  If 3 pixels are present, convolve them
	 do l=1,128
	  ax=decal(l)
          spec(l)=matrice(x,y,l)+0.5*ax*(matrice(x+1,y-1,l)-
     $matrice(x-1,y+1,l))
	 enddo
	else if(id.eq.35)then ! If one pixel is missing, interpolate
	 do l=1,128
	  ax=decal(l)
          spec(l)=0.5*((1.+ax)*matrice(x+1,y-1,l)+(1.-ax)*
     $matrice(x-1,y+1,l))
	 enddo
	else if(id.eq.15)then
	 do l=1,128
	  ax=decal(l)
	  spec(l)=matrice(x,y,l)+ax*(matrice(x,y,l)-matrice(x-1,y+1,l))
	 enddo
	else if(id.eq.21)then
	 do l=1,128
	  ax=decal(l)
	  spec(l)=matrice(x,y,l)+ax*(matrice(x+1,y-1,l)-matrice(x,y,l))
	enddo
	else if(id.eq.3)then  !If 2 neighboring pixels missing, no interpoll.
	 do l=1,128
	  spec(l)=matrice(x,y,l)
	enddo
	else 		! If central pixel and 1 neighbor missing, forget it.
	 temps(x,y)=0.
	 mir(x,y)=0.
	 tdet(x,y)=0.
	 do i=1,128
	   spec(i)=0.
	 enddo
	 goto 174 
	endif

	  if(Temps(x,y).eq.0)then  !If sample is missing compute time, etc
	 	temps(x,y)=0.5*(temps(x+1,y-1)+temps(x-1,y+1))
	 	mir(x,y)=0.5*(mir(x+1,y-1)+mir(x-1,y+1))
	 	tdet(x,y)=0.5*(tdet(x+1,y-1)+tdet(x-1,y+1))
	  endif
 
	  tdeg=49.96721-4.066708e-2*tdet(x,y)	!T en  Celsius
	  if(Tdeg.ne.Told)then
	    do i=1,128
	      corT(i)=(b3(i)*tdeg+b2(i))*tdeg+b1(i)
	    enddo
	    Told=Tdeg
	  endif


c	----- Corrects from background, gain, temperature -----

		if(gain0.eq.3)then
		 do i=1,128
		  spec(i)=(spec(i)/gain(i)-fond1(i))/gain3(i)/cort(i)
		 enddo
		endif
		if(gain0.eq.2)then
		 do i=1,128
		  spec(i)=(spec(i)/gain(i)-fond1(i))/gain2(i)/cort(i)
		 enddo
		endif 
		if(gain0.eq.1)then
		 do i=1,128
		  spec(i)=(spec(i)/gain(i)-fond1(i))/gain1(i)/cort(i)
		 enddo
		endif


c	----- Subtraction of additive components in the short wavelengths -----

	do i=63,128	! First order correction
	  wal(i)=spec(i)/mtf(i)
	end do
	lam(129)=2.*lam(128)-lam(127)
	wal(129)=2.*wal(127)-wal(125)
	do i=1,64
	    w2=2*lam(i)
	    do j=65+mod(i,2),128+mod(i,2),2
	      if(lam(j).gt.w2)goto 303
	    end do
303	    w3=((w2-lam(j-2))*wal(j)+(lam(j)-w2)*wal(j-2))/
     &		(lam(j)-lam(j-2))
	    if(j.eq.65) w3=((w2-lam(64))*wal(j)+(lam(j)-w2)*wal(64))/
     &		(lam(j)-lam(64))
	    if(j.eq.66) w3=((w2-lam(63))*wal(j)+(lam(j)-w2)*wal(63))/
     &		(lam(j)-lam(63))
	    spec(i)=spec(i)-m1d2(i)*w3
	end do

	do i=1,64	! Third order correction
	  wal(i+10)=spec(i)/mtf(i)
	  lamb(i+10)=lam(i)
	enddo
	lamb(10)=2.*lamb(11)-lamb(12)
	lamb(9)=2.*lamb(10)-lamb(12)
	wal(10)=2.*wal(12)-wal(14)
	wal(9)=2.*wal(11)-wal(13)
	do i=31,64
	    w2=2*lam(i)/3
	    do j=2-mod(i,2),64-mod(i,2),2
	      if(lamb(j+10).gt.w2)goto 304
	    end do
304	    w3=((w2-lamb(j-2+10))*wal(j+10)+(lamb(j+10)-w2)*wal(j-2+10))/
     &           (lamb(j+10)-lamb(j-2+10))
	    spec(i)=spec(i)-m3d2(i)*w3
	enddo


c	----- Division by transfer function and scaled Sun -----

		!Results = radiance factors

		do i=1,128	!Correction FT, distance au Soleil
		  spec(i)=spec(i)/mtf(i)*(raym**2)/sol(i) 
		enddo


c	----- Atmospheric Correction -----

		! Only if we've told him...
	If (rep2(1:1).ne.'y'.and.rep2(1:1).ne.'Y') goto 423

		alphap=alog((spec(73)+spec(87))/(spec(79)+spec(81)))
		alphai=alog((spec(72)+spec(88))/(2*spec(80)))

		do l=1,32
		   i=2*l
		   spec(i)=spec(i)/(exp(atm(i))**alphap)
		   i=2*l-1
		   spec(i)=spec(i)/(exp(atm(i))**alphai)
		enddo
		do l=33,64
		   i=2*l
		   spec(i)=spec(i)/(exp(atm(i))**alphai)
		   i=2*l-1
		   spec(i)=spec(i)/(exp(atm(i))**alphap)
		enddo


c	----- refine the temperature correction for high T image cubes  -----


423		if (fic.eq.'pav'.or.fic.eq.'bib'.or.fic.eq.'ara')then
	 	 do i=1,128
		  coefTt(i)=1+(coeft(i)-1)*(75.+tdeg)/(75.-70.4)
		  spec(i)=spec(i)*coefTt(i)
		 enddo
		endif


c	-----  recalibration relative to telescopic spectra  -----

		do i=1,128
		   spec(i)=(spec(i)-off(i))/coef(i)
		   if(spec(i).gt.0.5)spec(i) = 0.5	!In case of saturation.
		   if(spec(i).lt.0.0)spec(i) = 0.    !(this should be useless)
		enddo


c	----- Digitize the data and store the final array -----

174	jh=temps(x,y)/3600
	jm=amod(temps(x,y),3600.)/60
	js=amod(temps(x,y),60.)
	jtic=(temps(x,y)-int(temps(x,y)))*8
	buff(1)=jh
	buff(2)=jm
	buff(3)=js
	buff(4)=jtic
	buff(5)=x
	buff(6)=y
	buff(7)=tdeg*100
	buff(8)=mir(x,y)

	buff1(1)=jh
	buff1(2)=jm
	buff1(3)=js
	buff1(4)=jtic
	buff1(5)=x
	buff1(6)=y
	buff1(7)=tdeg*100
	buff1(8)=mir(x,y)

 	  do i=1,32
	   buff(i+8)=(spec(2*i)/0.5)*32767
	   buff1(i+8)=(spec(2*i-1)/0.5)*32767
	  enddo
	  do i=1,32
	   buff(i+40)=(spec(2*i+63)/0.5)*32767
	   buff1(i+40)=(spec(2*i+64)/0.5)*32767
	  enddo

	write(2'nbf)buff	!even channels
	write(1'nbf)buff1	!odd channels


c	----- End of main loop -----

	 enddo
	enddo

	type*,'nb of registered spectra',nbf
	type*,'The image is',xold,'lines x',ymax-1,' samples'

	close(1)
	close(2)


5	format(A13)
6	format(1x,3(I6,2x))
7	format(1x,A13)
21	format(3x,I3,3x,E11.5,3x,F6.4)
130	format(1x,I3,3x,3(E14.6))
141	format(a3)
150 	format(2I4,F10.3,2x,32F7.4)

	end
