	program convert

c   ===================================================================
c		Stphane ERARD, avril 95

c	Extracts spectral data and important parameters from raw data files
c	Must be linked with ddISM.obj

c   ===================================================================


	implicit none

	integer*2 	orinum(64),datnum(400),infnum(64),
     &			kp(128),kpc(128),i,par,tout,dep,gain0,mode,
     &			nbf,idtlng,inflng,rep1,mir(300,50),
     &			ih,im,is,jh,jm,js,gain,
     &			Mirmin,x,y,xold,yold,drty,l,ymax,ymin,
     &			jtic,tdet(300,50),spec(72),spec1(72)

	real*4		sc,temps(300,50),raym,
     &			sdf,sff,ss,
     &			sder,matrice(0:300,50,128)

			
	byte	 	inftab(128),oritab(128)
	character*55 	nom,ch2,ch
	character*128 	infstr
	character*15	fic,rep,calsi
	character*25	nomf

	equivalence (infnum,inftab)
	equivalence (inftab,infstr)
	equivalence (orinum,oritab)


	data kpc/163, 99,162, 98,161, 97,160, 96,159, 95,158, 94,
     1        157, 93,156, 92,155, 91,154, 90,153, 89,152, 88,
     2        151, 87,150, 86,149, 85,148, 84,147, 83,146, 82,
     3        145, 81,144, 80,143, 79,142, 78,141, 77,140, 76,
     4        139, 75,138, 74,137, 73,136, 72,135, 71,134, 70,
     5        133, 69,132, 68,131,195,130,194,129,193,128,192,
     6        127,191,126,190,125,189,124,188,123,187,122,186,
     7        121,185,120,184,119,183,118,182,117,181,116,180,
     8        115,179,114,178,113,177,112,176,111,175,110,174,
     9        109,173,108,172,107,171,106,170,105,169,104,168,
     9        103,167,102,166,101,165,100,164/

	data kp/131,195,130,194,129,193,128,192,
     6        127,191,126,190,125,189,124,188,123,187,122,186,
     7        121,185,120,184,119,183,118,182,117,181,116,180,
     8        115,179,114,178,113,177,112,176,111,175,110,174,
     9        109,173,108,172,107,171,106,170,105,169,104,168,
     9        103,167,102,166,101,165,100,164,
     1        163, 99,162, 98,161, 97,160, 96,159, 95,158, 94,
     1        157, 93,156, 92,155, 91,154, 90,153, 89,152, 88,
     2        151, 87,150, 86,149, 85,148, 84,147, 83,146, 82,
     3        145, 81,144, 80,143, 79,142, 78,141, 77,140, 76,
     4        139, 75,138, 74,137, 73,136, 72,135, 71,134, 70,
     5        133, 69,132, 68/



558	idtlng=400
	inflng=400

	write(6,*)'File Name?'
	read(5,5)nom
	ch='$1$DUA1:[PCCOMMON.BASEISM.RAW_DATA.FLIGHT]'
	ch2=' '
	if(nom(1:9).eq.'corpnoir.')then
c		nomf='fond0802.dat'
c		gain0=1
		ih=12
		im=18
		is=27
		jh=12
		jm=55
		js=40
		ymax=1
		mirmin=12
c		raym=1.54679
		fic='cno'
		ch='$1$DUA1:[PCCOMMON.BASEISM.RAW_DATA.GROUND]'
		do i=1, 128	!Correct channels order for ground-cal files
		 kp(i)=kpc(i)
		enddo
	endif
	if(nom(1:9).eq.'mars0802.')then
		nomf='fond0802.dat'
		gain0=1
		ih=11
		im=05
		is=21
		jh=11
		jm=12
		js=08
		ymax=9
		mirmin=12
		raym=1.54679
		fic='pav'
	endif
	if(nom(1:9).eq.'mars1102.')then
		nomf='fond1102.dg2'
		gain0=2
		ih=16
		im=51
		is=43
		jh=16
		jm=58
		js=00
		ymax=9
		mirmin=233
		raym=1.55088
		fic='bib'
	endif
	if(nom(1:9).eq.'mars0103.')then
		nomf='fond0103.dg2'
		gain0=2
		ih=10
		im=45
		is=28
		jh=11
		jm=12
		js=36
		ymax=26
		mirmin=222
		raym=1.572447
		fic='syr'
	endif
	if(nom(1:9).eq.'mars1303.')then
		nomf='fond1303.dg2'
		gain0=2
		ih=11
		im=55
		is=25
		jh=12
		jm=15
		js=54
		ymax=26
		mirmin=156
		raym=1.587290
		fic='oly'
	endif
	if(nom(1:9).eq.'mars0703.')then
		nomf='fond0703.dat'
		gain0=1
		ih=3
		im=0
		is=47
		jh=3
		jm=27
		js=53
		ymax=26
		mirmin=2
		raym=1.579486
		fic='vmc'
	endif
	if(nom(1:9).eq.'mars2102.')then
		nomf='fond2102.dg2'
		gain0=2
		ih=10
		im=23
		is=3
		jh=10
		jm=44
		js=58
		ymax=26
		mirmin=228
		raym=1.562730
		fic='ara'
	endif
        if(nom(1:9).eq.'mars2202.')then
                nomf='fond2102.dg2'
                gain0=2
                ih=2
                im=28
                is=3
                jh=2
                jm=55
                js=7
                ymax=26
                mirmin=228
                raym=1.562730   !More or less
                fic='spin'
        endif
	if(nom(1:9).eq.'mars2702.')then
		nomf='fond2702.dg2'
		gain0=2
		ih=2
		im=41
		is=42
		jh=3
		jm=8
		js=51
		ymax=26
		mirmin=26
		raym=1.570081
		fic='dae'
	endif
	if(nom(1:9).eq.'mars1203.')then
		nomf='fond1403.dg2'
		gain0=2
		ih=3
		im=23
		is=42
		jh=3
		jm=50
		js=47
		ymax=26
		mirmin=2
		raym=1.585198
		fic='aur'
	endif
	if(nom(1:9).eq.'mars2603.')then
		nomf='fond2603.dg2'
		gain0=2
		ih=15
		im=03
		is=59
		jh=15
		jm=30
		js=52
		ymax=26
		mirmin=198
		raym=1.600988
		fic='heb'
	endif
	if(nom(1:9).eq.'mars2103.')then
		nomf='fond2103.dg3'
		gain0=3
		ih=12
		im=20
		is=36
		jh=12
		jm=47
		js=38
		ymax=26
		mirmin=162
		raym=1.595524
		fic='asc'
	endif
	if(nom(1:9).eq.'mars1403.')then
		nomf='fond1403.dg2'
		gain0=2
		ih=11
		im=50
		is=24
		jh=12
		jm=17
		js=25
		ymax=26
		mirmin=210
		raym=1.587860
		fic='gor'
	endif
	if(nom(1:9).eq.'phob2503.')then
c		nomf='fond2103.dg3'
		gain0=2
		ih=16
		im=11
		is=51
		jh=16
		jm=17
		js=15
		ymax=26
		mirmin=240
c		raym=1.600988
		fic='pho'
	endif

	if(ymax.ne.0)then
		write(6,*)'Main session (y/n)?'
		read(5,141) rep
	else
		rep='n'
	endif
	if (rep.ne.'y') then
	 type *,' Start time?'
         accept *,ih,im,is
         type *,' End time?'
         accept *,jh,jm,js
	 type *,' Is this a (flight) calibration session (y/n)?'
	 accept 5, calsi
	 if (calsi.ne.'y'.and.calsi.ne.'Y')then
	  type *,'Minimum mirror position?'
	  accept *, mirmin
	  type *,'Number of pixels per line?'
	  accept *, ymax 
	 else
	  mirmin=0
	  ymax=1
	 endif
	 type *,'Root of output file name?'
	 accept 5, fic
        endif

	drty=1
	open(unit=8,file=ch//nom,status='old',shared,carriagecontrol
     $='list',form='unformatted',recordtype='fixed',recordsize=32)
	
	sdf=ih*10000.+im*100.+is
	type *,'Starts at ',sdf
	sff=jh*10000.+jm*100.+js
	type *,'Ends at ',sff
	tout=1

	nbf=0
	rep1=0
	xold=1
	yold=0
	if(ymax.eq.1) xold=0	! If one sample/line

198	read(8,end=300,err=5000)(orinum(i),i=1,64) 
	read(8,end=300,err=5000)(infnum(i),i=1,64)
        call ddism(orinum,datnum,idtlng,infnum,inflng)

	if(datnum(1).gt.1) go to 198	!other than science ISM
 	sc=datnum(8)*10000.+datnum(9)*100.+datnum(10)+datnum(11)*.125
	if(sc.lt.sdf) goto198		!Wait for starting time

c		Corrects a date on Phobos
	if (fic.eq.'pho'.and.sc.eq.161520.875)then
	 if (drty.eq.3)then
		sc=161523.875
	 else
		drty=drty+1
	 endif
	endif
	if(sc.le.sder) goto 198		!Forbid come back

c		Corrects some telemetry errors in datation
	if (fic.eq.'bib'.and.sc.eq.305705.5)sc=165705.5
	if (fic.eq.'syr'.and.sc.eq.270724.625)sc=110724.625
	if (fic.eq.'syr'.and.sc.eq.231153.75)sc=111153.75

	if(sc.gt.235959) goto198	!Forget wrong timings
	if(sc.gt.sff+1)then		!Check continuity
	 if(dep.eq.1)goto298
	 dep=1
	 goto198
	endif
	dep=0
	par=1			!look for the 2nd block
	if((sc.eq.ss).and.(rep1.eq.1).and.(datnum(1).eq.par)) then
	 rep1=0
	 if(tout.eq.1)then
	  tout=0
	  sdf=sc
	  ih=sdf/10000
	  im=amod(sdf,10000.)/100
	  is=amod(sdf,100.)
	 endif
	 nbf=nbf+1
	 sder=sc

	 y=datnum(29)-mirmin+1

c	Mars global mode
	 if(ymax.eq.50)then
	  if(datnum(29).lt.mirmin) datnum(29)=datnum(29)+256
	  if(datnum(29).gt.mirmin+256) datnum(29)=datnum(29)-256
	  y=(datnum(29)-mirmin)/4+1
	 endif

	 if(y.le.0) y=y+256

c	Skip the first line in window mode
	 if(ymax.gt.1.and.y.eq.1) goto 198

c	Correct two telemetry errors on mirror positions
	 if(fic.eq.'syr'.and.x.eq.80.and.y.eq.18.and.drty.eq.1)then
		y=6
		drty=0
	 endif
	 if(fic.eq.'pho'.and.x.eq.24.and.y.eq.65)then
		y=17
	 endif

	 if(y.ge.yold)then
 		x=xold
 	 else	! ...next line
		x=xold+1
		type*,nbf,x,yold
	 endif
	 if(ymax.eq.1) then	! If one sample/line
		y=1
		x=xold+1
		type*,nbf,x,y
	 endif
	 yold=y
	 xold=x

	 tdet(x,y)=datnum(45)
	 temps(x,y)=sc
	 mir(x,y)=datnum(65)
	 if (calsi.eq.'y'.or.calsi.eq.'Y')then
	  gain=(2*datnum(16)+1)*(datnum(17)+1)
	  mode=datnum(6)
	  mir(x,y)=mode*256+gain !For calib sessions, stock gain and mode
	 endif			 ! instead of mirror (always in rest position)

c	 if(ymax.eq.1) mir(x,y)=0 !In track mode, mirror in rest position

	 do l=1,128		!spectral measurements
	   matrice(x,y,l)=datnum(kp(l))
	 enddo

	else	!Just found the first block; wait for the second one

		ss=sc
		rep1=1
	endif
	goto198				! Next pixel

300	if(nbf.ne.0)goto298		! Normal ending
	type*,'Timing problem'
	stop
5000    type *,'End of file'		! End time too high
	stop

298	close(8)
	if(nbf.eq.0)goto 300

	jh=ss/10000
	jm=amod(ss,10000.)/100
	js=amod(ss,100.)
	jtic=(temps(x,y)-int(temps(x,y)))*8
	type*,'End in line',xold,', sample',yold
	type*,'    at ',jh,':',jm,':',js
	type*,'Nb of spectra read:',nbf
	Type*,'Formatting the data...'


c	**** Corrections of telemetry errors ****

	if(fic.eq.'bib')then
	 do i=9,26
	  tdet(42,i)=2965	!Correct a telemetry error 
	 enddo
	 tdet(43,2)=2965	!in temperature.
	 temps(234,7)=165705.5	! ...and a wrong timing

	 do i=1,128
	  matrice(42,8,i)=0.	! Skip rotten even spectra
	  matrice(140,5,i)=0.
	  matrice(175,8,i)=0.
	 enddo
	 temps(42,8)=0.
	 temps(140,5)=0.
	 temps(175,8)=0.
	 mir(42,8)=0
	 mir(140,5)=0
	 mir(175,8)=0
	 tdet(42,8)=0
	 tdet(140,5)=0
	 tdet(175,8)=0
	
	 matrice(14,4,67)=matrice(14,4,67)+260		!Glitches
	 matrice(49,9,127)=matrice(49,9,127)-10
	 matrice(50,8,104)=matrice(50,8,104)-768
	 matrice(55,7,20)=matrice(55,7,20)+1024
	 matrice(56,6,52)=matrice(56,6,52)-2048
	 matrice(58,9,125)=matrice(58,9,125)+16
	 matrice(83,8,123)=matrice(83,8,123)-3584
	 matrice(90,3,59)=matrice(90,3,59)-768
	 matrice(91,5,110)=matrice(91,5,110)-64
	 matrice(103,4,126)=matrice(103,4,126)+32
	 matrice(147,3,35)=matrice(147,3,35)-3072
	 matrice(153,2,126)=matrice(153,2,126)-12
	 matrice(161,9,115)=matrice(161,9,115)-3072
	 matrice(170,9,128)=matrice(170,9,128)-8
	 matrice(178,2,125)=matrice(178,2,125)-8
	 matrice(178,9,128)=matrice(178,9,128)-8
	 matrice(182,4,45)=matrice(182,4,45)-192
	 matrice(183,8,123)=matrice(183,8,123)-1792
	 matrice(192,8,44)=matrice(192,8,44)-1536
	 matrice(192,8,127)=matrice(192,8,127)-8
	 matrice(208,9,128)=matrice(208,9,128)+12
	 matrice(209,3,68)=matrice(209,3,68)-2048
	 matrice(212,2,125)=matrice(212,2,125)-1792
	 matrice(213,6,9)=matrice(213,6,9)-3072
	 matrice(213,6,13)=matrice(213,6,13)-2806
	 matrice(213,6,15)=matrice(213,6,15)-2806
	 matrice(213,6,19)=matrice(213,6,19)-1536
	 matrice(221,2,69)=matrice(221,2,69)+630
	 matrice(221,8,44)=matrice(221,8,44)-1536
	 matrice(223,2,127)=matrice(223,2,127)+8
	 matrice(224,9,127)=matrice(224,9,127)-8
	 matrice(240,4,125)=matrice(240,4,125)-12
	 matrice(247,2,123)=matrice(247,2,123)-16
	 matrice(259,9,127)=matrice(259,9,127)-8
	 matrice(273,9,127)=matrice(273,9,127)-8
	endif

	if(fic.eq.'ara')then
	 matrice(12,24,25)=matrice(12,24,25)-256
	 matrice(23,2,125)=matrice(23,2,125)+8
	 matrice(23,2,128)=matrice(23,2,128)+8
	 matrice(60,24,89)=matrice(60,24,89)-2048
	 matrice(67,21,16)=matrice(67,21,16)+512
	endif

	if(fic.eq.'dae')then
	 matrice(1,20,22)=matrice(1,20,22)-1792
	 matrice(3,20,117)=matrice(3,20,117)-1536
	 matrice(4,24,119)=matrice(4,24,119)-2048
	 matrice(9,17,70)=matrice(9,17,70)-1024
	 matrice(21,16,78)=matrice(21,16,78)-2048
	 matrice(22,19,13)=matrice(22,19,13)-768
	 matrice(23,11,24)=matrice(23,11,24)-630
	 matrice(27,26,92)=matrice(27,26,92)-2048
	 matrice(36,10,128)=matrice(36,10,128)+80
	 matrice(41,12,29)=matrice(41,12,29)-2048
	 matrice(46,9,8)=matrice(46,9,8)-2048
	 matrice(49,22,102)=matrice(49,22,102)-768
	 matrice(62,10,128)=matrice(62,10,128)-3584
	 matrice(66,12,110)=matrice(66,12,110)-2048
	 matrice(67,8,21)=matrice(67,8,21)-2048
	 matrice(69,3,117)=matrice(69,3,117)-3072
	 matrice(80,24,126)=matrice(80,24,126)-3072
	 matrice(81,9,125)=matrice(81,9,125)-2048
	 matrice(84,9,102)=matrice(84,9,102)-768
	 matrice(90,4,48)=matrice(90,4,48)-192
	 matrice(90,10,5)=matrice(90,10,5)-2048
	 matrice(94,21,15)=matrice(94,21,15)-160
	 matrice(102,8,64)=matrice(102,8,64)+160
	 matrice(105,9,110)=matrice(105,9,110)-2048
	 matrice(108,18,63)=matrice(108,18,63)-384
	 matrice(110,24,1)=matrice(110,24,1)-1792
	 matrice(120,6,30)=matrice(120,6,30)-2048
	endif

	if(fic.eq.'syr')then
	 temps(98,11)=110724.625
	 temps(118,9)=111153.75
	 do i=1,128
	  matrice(49,9,i)=0.
	 enddo
	 temps(49,9)=0.
	 mir(49,9)=0
	 tdet(49,9)=0.

	 matrice(1,24,96)=matrice(1,24,96)-768
	 matrice(1,24,100)=matrice(1,24,100)-1536
	 matrice(1,26,127)=matrice(1,26,127)-4
	 matrice(4,22,107)=matrice(4,22,107)-3072
	 matrice(5,2,127)=matrice(5,2,127)-4
	 matrice(9,2,65)=matrice(9,2,65)-32
	 matrice(11,26,46)=matrice(11,26,46)-512
	 matrice(11,26,127)=matrice(11,26,127)-4
	 matrice(12,20,127)=matrice(12,20,127)+4
	 matrice(16,14,125)=matrice(16,14,125)-4
	 matrice(17,26,102)=matrice(17,26,102)+128
	 matrice(20,7,127)=matrice(20,7,127)-4
	 matrice(21,4,127)=matrice(21,4,127)-4
	 matrice(24,15,13)=matrice(24,15,13)+128
	 matrice(26,2,125)=matrice(26,2,125)-4
	 matrice(26,26,127)=matrice(26,26,127)-4
	 matrice(28,6,127)=matrice(28,6,127)-4
	 matrice(30,9,128)=matrice(30,9,128)-4
	 matrice(30,26,125)=matrice(30,26,125)-8
	 matrice(32,11,123)=matrice(32,11,123)-3072
	 matrice(38,19,3)=matrice(38,19,3)-3072
	 matrice(40,2,77)=matrice(40,2,77)-256
	 matrice(41,7,120)=matrice(41,7,120)+8
	 matrice(43,19,83)=matrice(43,19,83)-3072
	 matrice(44,11,60)=matrice(44,11,60)-3584
	 matrice(44,26,80)=matrice(44,26,80)-192
	 matrice(44,26,106)=matrice(44,26,106)-48
	 matrice(44,26,108)=matrice(44,26,108)-10
	 matrice(46,8,116)=matrice(46,8,116)-2048
	 matrice(47,2,127)=matrice(47,2,127)-4
	 matrice(48,11,4)=matrice(48,11,4)-2048
	 matrice(49,12,119)=matrice(49,12,119)-32
	 matrice(50,2,127)=matrice(50,2,127)-4
	 matrice(53,9,21)=matrice(53,9,21)+160
	 matrice(67,13,67)=matrice(67,13,67)+1024
	 matrice(74,10,126)=matrice(74,10,126)-256
	 matrice(75,9,108)=matrice(75,9,108)-3584
	 matrice(76,8,127)=matrice(76,8,127)+20
	 matrice(82,9,115)=matrice(82,9,115)-3072
	 matrice(87,20,116)=matrice(87,20,116)-3072
	 matrice(88,4,78)=matrice(88,4,78)-2048
	 matrice(89,3,91)=matrice(89,3,91)-3072
	 matrice(91,14,12)=matrice(91,14,12)-2048
	 matrice(96,13,84)=matrice(96,13,84)-2048
	 matrice(97,20,109)=matrice(97,20,109)-192
	 matrice(105,9,52)=matrice(105,9,52)-2048
	 matrice(109,9,116)=matrice(109,9,116)-2048
	 matrice(110,10,36)=matrice(110,10,36)-2048
	 matrice(113,2,86)=matrice(113,2,86)-2048
	 matrice(114,25,128)=matrice(114,25,128)-32
	 matrice(115,23,35)=matrice(115,23,35)-3072
	 matrice(117,23,103)=matrice(117,23,103)-256
	 matrice(117,25,123)=matrice(117,25,123)-32
	 matrice(118,12,127)=matrice(118,12,127)+128
	 matrice(118,25,31)=matrice(118,25,31)+768
	 matrice(118,26,97)=matrice(118,26,97)-1024
	 matrice(119,4,88)=matrice(119,4,88)-2048
	 matrice(119,5,27)=matrice(119,5,27)-2560
	 matrice(119,10,33)=matrice(119,10,33)-1434
	 matrice(119,10,37)=matrice(119,10,37)+192
	 matrice(119,11,14)=matrice(119,11,14)-1024
	 matrice(119,15,121)=matrice(119,15,121)-228
	 matrice(119,22,23)=matrice(119,22,23)-2048
	 matrice(119,22,27)=matrice(119,22,27)+256
	 matrice(120,6,44)=matrice(120,6,44)-192
	 matrice(121,9,45)=matrice(121,9,45)-2048

	 matrice(7,22,3)=matrice(7,22,3)-2304	!Eventually interpolate
	 matrice(7,22,5)=matrice(7,22,5)-2592	! two odd spectra, to avoid
	 matrice(7,22,7)=matrice(7,22,7)+48	! loss of data on even channels
	 matrice(7,22,9)=matrice(7,22,9)-32
	 matrice(7,22,11)=matrice(7,22,11)-3344
	 matrice(7,22,13)=matrice(7,22,13)-3712
	 matrice(7,22,19)=matrice(7,22,19)-544
	 matrice(7,22,21)=matrice(7,22,21)-448
	 matrice(7,22,23)=matrice(7,22,23)-128
	 matrice(7,22,27)=matrice(7,22,27)-2560
	 matrice(7,22,29)=matrice(7,22,29)-1856
	 matrice(7,22,31)=matrice(7,22,31)-96
	 matrice(7,22,35)=matrice(7,22,35)-1536
	 matrice(7,22,37)=matrice(7,22,37)-1408
	 matrice(7,22,39)=matrice(7,22,39)-96
	 matrice(7,22,43)=matrice(7,22,43)-448
	 matrice(7,22,45)=matrice(7,22,45)-512
	 matrice(7,22,51)=matrice(7,22,51)-2560
	 matrice(7,22,53)=matrice(7,22,53)-2720
	 matrice(74,21,1)=matrice(74,21,1)-48
	 matrice(74,21,3)=matrice(74,21,3)-3600
	 matrice(74,21,5)=matrice(74,21,5)-104
	 matrice(74,21,7)=matrice(74,21,7)-64
	 matrice(74,21,9)=matrice(74,21,9)-112
	 matrice(74,21,11)=matrice(74,21,11)-2340
	 matrice(74,21,13)=matrice(74,21,13)-3200
	 matrice(74,21,15)=matrice(74,21,15)-128
	 matrice(74,21,17)=matrice(74,21,17)-148
	 matrice(74,21,19)=matrice(74,21,19)-1184
	 matrice(74,21,21)=matrice(74,21,21)-1712
	 matrice(74,21,27)=matrice(74,21,27)-2560
	 matrice(74,21,29)=matrice(74,21,29)-1680
	 matrice(74,21,35)=matrice(74,21,35)-264
	 matrice(74,21,39)=matrice(74,21,39)+256
	 matrice(74,21,43)=matrice(74,21,43)-1664
	 matrice(74,21,45)=matrice(74,21,45)-1792
	 matrice(74,21,47)=matrice(74,21,47)-224
	 matrice(74,21,51)=matrice(74,21,51)-800
	 matrice(74,21,53)=matrice(74,21,53)-1184
	 matrice(74,21,55)=matrice(74,21,55)+160
	 matrice(74,21,57)=matrice(74,21,57)+128
	 matrice(74,21,59)=matrice(74,21,59)-864
	 matrice(74,21,61)=matrice(74,21,61)-256
	 matrice(74,21,63)=matrice(74,21,63)-1408
	 matrice(74,21,66)=matrice(74,21,66)-1376
	 matrice(74,21,68)=matrice(74,21,68)-1824
	 matrice(74,21,72)=matrice(74,21,72)+640
	 matrice(74,21,84)=matrice(74,21,84)-528
	 matrice(74,21,86)=matrice(74,21,86)-320
	 matrice(74,21,92)=matrice(74,21,92)-2624
	 matrice(74,21,94)=matrice(74,21,94)-1088
	 matrice(74,21,98)=matrice(74,21,98)+176
	 matrice(74,21,100)=matrice(74,21,100)-640
	 matrice(74,21,102)=matrice(74,21,102)-512
	 matrice(74,21,104)=matrice(74,21,104)+512
	 matrice(74,21,106)=matrice(74,21,106)+320
	 matrice(74,21,108)=matrice(74,21,108)-3296
	 matrice(74,21,110)=matrice(74,21,110)-2576
	 matrice(74,21,112)=matrice(74,21,112)-176
	 matrice(74,21,114)=matrice(74,21,114)+56
	 matrice(74,21,116)=matrice(74,21,116)-976
	 matrice(74,21,118)=matrice(74,21,118)-512
	 matrice(74,21,120)=matrice(74,21,120)+234
	 matrice(74,21,122)=matrice(74,21,122)+48
	 matrice(74,21,124)=matrice(74,21,124)+32
	 matrice(74,21,126)=matrice(74,21,126)-3760
	endif

	if(fic.eq.'vmc')then
	 do i=1,128
	  matrice(13,13,i)=0.
	 enddo
	 temps(13,13)=0.
	 mir(13,13)=0
	 tdet(13,13)=0

	 matrice(14,26,127)=matrice(14,26,127)+4
	 matrice(77,26,127)=matrice(77,26,127)+4
	 matrice(93,26,127)=matrice(93,26,127)+4
	endif

	if(fic.eq.'oly')then
	 matrice(90,26,127)=matrice(90,26,127)-8
	endif

	if(fic.eq.'gor')then
	 matrice(14,19,93)=matrice(14,19,93)-3072
	 matrice(19,14,44)=matrice(19,14,44)-2048
	endif

	if(fic.eq.'asc')then
	 matrice(62,16,126)=matrice(62,16,126)+64
	endif

	if(fic.eq.'heb')then
	 do i=1,128
	  matrice(93,26,i)=0.
	 enddo
	 temps(93,26)=0.
	 mir(93,26)=0
	 tdet(93,26)=0
	 matrice(52,26,109)=matrice(52,26,109)+16
	 matrice(76,26,127)=matrice(76,26,127)+8
	endif

	if(fic.eq.'pho')then
	 mir(11,23)=2143
	 do i=1,128
	  matrice(17,21,i)=0.5*(matrice(17,20,i)+matrice(17,22,i))
	 enddo
	 temps(17,21)=161537.875
	 mir(17,21)=2114
	 tdet(17,21)=3115

	 matrice(1,6,97)=matrice(1,6,97)-512
	 matrice(3,8,10)=matrice(3,8,10)-2816
	 matrice(3,8,14)=matrice(3,8,14)+32
	 matrice(5,13,41)=matrice(5,13,41)-2048
	 matrice(11,23,4)=matrice(11,23,4)-3328
	endif


	if(fic.eq.'spin')then
	 matrice(3,19,56)=matrice(3,19,56)+416
	 matrice(6,16,69)=matrice(6,16,69)-1536
	 matrice(19,24,17)=matrice(19,24,17)-2560
	 matrice(21,7,2)=matrice(21,7,2)-1280
	 matrice(21,7,4)=matrice(21,7,4)-1824
	 matrice(21,7,6)=matrice(21,7,6)+1280
	 matrice(21,7,10)=matrice(21,7,10)+2304
	 matrice(21,7,12)=matrice(21,7,12)+1024
	 matrice(21,7,14)=matrice(21,7,14)+1056
	 matrice(33,20,23)=matrice(33,20,23)-80
	 matrice(33,20,25)=matrice(33,20,25)-104
	 matrice(38,8,11)=matrice(38,8,11)+96
	 matrice(38,8,17)=matrice(38,8,17)+104
	 matrice(39,10,37)=matrice(39,10,37)+640
	 matrice(82,12,82)=matrice(82,12,82)+1280
	 matrice(86,13,88)=matrice(86,13,88)-2048
	endif


c	****	Prepare the array  ****


	nbf=0
	open(1,file=ch2//fic//'odd.edt',form='unformatted',recl=36,
     &access='direct',status='new')
	open(2,file=ch2//fic//'even.edt',form='unformatted',recl=36,
     &access='direct',status='new')
	ymin=1
	if (ymax.gt.1) ymin=2
	do x=1,xold
	 do y=ymin,ymax
	  nbf=nbf+1

	  jh=temps(x,y)/10000
	  jm=amod(temps(x,y),10000.)/100
	  js=amod(temps(x,y),100.)
	  jtic=(temps(x,y)-int(temps(x,y)))*8
	spec(1)=jh
	spec(2)=jm
	spec(3)=js
	spec(4)=jtic
	spec(5)=x
	spec(6)=y
	spec(7)=tdet(x,y)
	spec(8)=mir(x,y)
	spec1(1)=jh
	spec1(2)=jm
	spec1(3)=js
	spec1(4)=jtic
	spec1(5)=x
	spec1(6)=y
	spec1(7)=tdet(x,y)
	spec1(8)=mir(x,y)

	  do i=1,32
	   spec(i+8)=matrice(x,y,2*i)
	   spec1(i+8)=matrice(x,y,2*i-1)
	  enddo
	  do i=1,32
	   spec(i+40)=matrice(x,y,2*i+63)
	   spec1(i+40)=matrice(x,y,2*i+64)
	  enddo

c		----- Writes the final array -----

	write(2'nbf)spec	!even channels
	write(1'nbf)spec1	!odd channels

c	----- End of main loop -----

174	 enddo
	enddo
	type*,'nb of registered raw spectra',nbf
	type*,'The image is',xold,'lines x',ymax-ymin+1,' samples'

	close(2)
	close(1)


141	format(a1)
5	format(A20)
150 	format(7(I4),10I6)
	end
