pro affspe, nom, niv2, niv4, lam2, lam4,PS = ps, DIR =dir

;+
; NAME
; affspe
;
; PURPOSE
; Plots ISM spectra and calibration files in asciii. response for even or odd channels 
; Assume the following format:
;
; tab1(0,128)	Channel number
; tab2(1,128)   Reflectance values
; tab3(2,128)   Wavelengths in increasing order
;
;	Separates even channels (plotted in red) and
;	odd channels (plotted in green).
;
; CALLING SEQUENCE:
;	affspe, filename, [niv2, niv4, lam2, lam4]
;
;
; INPUT PARAMETER:
; nom : name of the file to be plotted

; OUTPUT PARAMETERS:
; niv2, niv4: intensities in even channels, short and long wavelength range
; lam2, lam4: corresponding wavelengths.
;	Error:   Error flag
;
; KEYWORD PARAMETERS:
;  DIR     Provides the directory where the file is
;  PS      writes a PostScript file if set
;
; MODIFICATION HISTORY:
;	Stephane Erard, june 1995
;     updated, SE, may 2001
;
;--------------------------------------------------



tab1=fltarr(3,128)
lam1=fltarr(32)
lam2=fltarr(32)
lam3=fltarr(32)
lam4=fltarr(32)
niv1=fltarr(32)
niv2=fltarr(32)
niv3=fltarr(32)
niv4=fltarr(32)

smu='!4l!X'
nomf = nom
if keyword_set(dir) then nomf=dir+nom
openr, unit, nomf, /get_lun
readf, unit, tab1
free_lun, unit

nom1=nom
i=strpos(nom,':')
if i ne -1 then nom1=strmid(nom,i+1,strlen(nom))

lam=tab1(2,*)
niv=tab1(1,*)
for i=0,62,2 do niv1(i/2)=tab1(1,i)	; I
for i=0,62,2 do niv2(i/2)=tab1(1,i+1)	; P
for i=64,127,2 do niv3(i/2-32)=tab1(1,i+1)	;I
for i=64,127,2 do niv4(i/2-32)=tab1(1,i)	;P
for i=0,62,2 do lam1(i/2)=tab1(2,i)
for i=0,62,2 do lam2(i/2)=tab1(2,i+1)
for i=64,127,2 do lam3(i/2-32)=tab1(2,i+1)
for i=64,127,2 do lam4(i/2-32)=tab1(2,i)
mini=min(tab1(1,*))
maxi=max(tab1(1,*))

window, /free
loadct, 12

!Y.margin=[8.,8.]
!P.noclip=1

plot, [0.7,3.2], [mini,maxi], title=nom1, /xstyle, xtitle='Wavelength ('+smu+'m)',$
 ytitle="Level",/nodata,/ynozero, xcharsize=1.1, ycharsize=1.1
oplot, lam1, niv1, color=33, thick=1
oplot, lam2, niv2, color=180, thick=1
oplot, lam3, niv3, color=33, thick=1
oplot, lam4, niv4, color=180, thick=1

ymin= !Y.crange(0)-(!Y.crange(1)-!Y.crange(0))/0.96*0.1
;print, Ymin
 oplot, [0.7, 0.9],[ymin,ymin], color=180, thick=2 ; pairs
 oplot, [2.6,2.8],[ymin,ymin], color=33, thick=2 ; impairs
 xyouts, 1.0, ymin, 'even channels'
 xyouts, 2.9, ymin, 'odd channels'

if keyword_set(ps) then begin
 devori=!D.name
 set_plot,'ps'
 device,filename='spectrum.ps',/landscape,/helvetica, /color
 oldfont=!P.font
 !P.font=0
 th=4.
 smu='!Mm!X'


!P.noclip=1
plot, [0.7,3.2], [mini,maxi], title=nom1, /xstyle, xtitle='Wavelength ('+smu+'m)',$
 ytitle="Reflectance",/nodata, xcharsize=1.1, ycharsize=1.1, /ynozero
 oplot, lam1, niv1, linestyle=1, thick=th, color=33
 oplot, lam2, niv2, linestyle=0, thick=th, color=180
 oplot, lam3, niv3, linestyle=1, thick=th, color=33
 oplot, lam4, niv4, linestyle=0, thick=th, color=180

ymin= !Y.crange(0)-(!Y.crange(1)-!Y.crange(0))/0.96*0.2

 oplot, [0.7, 0.9],[ymin,ymin], color=180, thick=th ; pairs
 oplot, [2.6,2.8],[ymin,ymin], color=33, thick=th ; impairs
 xyouts, 1.0, ymin, 'even channels'
 xyouts, 2.9, ymin, 'odd channels'

 device, /close
 set_plot,devori
 !P.font=oldfont
endif

 !Y.margin=[4.,2.]

end
