pro affrep, ODD= odd

;--------------------------------------------------

;+
; NAME
; affrep
;
; PURPOSE
; Plots ISM spectral response for even or odd channels 
; (files reponses.dat or reponsesi.dat). The values were measured 
; with a monochromator with specral sampling ~12 times ISM spectral sampling.
;
; CALLING SEQUENCE:
;	affrep, [/ODD])
;
; KEYWORD PARAMETER:
; /ODD     Plots odd channels (Use file reponsesI.dat)
;
; SUBROUTINES:
; Calls ISM_rep
;
; MODIFICATION HISTORY:
;	Stephane Erard, june 1995
;     updated, SE, may 2001
;
;--------------------------------------------------



tit1 = 'Even channels'
IF not Keyword_Set(odd) THEN odd=0
if Keyword_Set(odd) then tit1 = 'Odd channels'
ISM_REP, lam, niv, odd= odd

plot, [0.5,3.5], [0,1], title='Spectral response'+'!C'+tit1, xtitle="Wavelength", $
 ytitle="Relative detectivity",/nodata,/xstyle,/ystyle, position=[0.1,0.1,.9,.9]

for i=0,63 do oplot, lam(i,*), niv(i,*), color=i/4*15+1

end
