
! DUSTEM - Dust Emissivity
! See: Desert et al., 1986, A&A 160, 295 for temperature distribution
! 2008-09:  unique spectral range and new dust properties: M Compiegne
! 2009: code fully rewritten: L Verstraete & J Le Bourlot
! 2009-10: add size dist parameters, beta function & output: LV
! 2010: first add of polarization: LV, L Masson & V Guillet
!       add DCD-TLS and spinning: N Ysard & LV
! 2012: add charge distribution (Weingartner & Draine 2001): LV 
! 2016: polarization completed (grain orientation and alignement): V Guillet  
! 2017: add Kimura 2016 model for photemission, add amC:H correction to thresholds: LV
! 2019: add ionization and H2 equilibrium values for gas abundances: LV
! 2020: add size dependent mass density: LV

PROGRAM DUSTEM

  USE CONSTANTS
  USE UTILITY
  USE MCOMPUTE
  USE IN_OUT

  IMPLICIT NONE

  REAL (KIND=dp) t1

  CALL READ_DATA
  CALL COMPUTE
  CALL WRITE_DATA

  CALL CPU_TIME (t1)

  IF (n_quiet == 0) THEN
     WRITE (*,*) ''
     WRITE (*,FMT='(A20,1PE8.2,A4)')'Exit OK - CPU Time ', t1,' sec'
     WRITE (*,*) '==========================================='
  ENDIF

END PROGRAM DUSTEM
