def add_mod( nsz=0, sf=0, tag='', unit='' ):

    from numpy import size,double
    
    if nsz == 0:
        print('-----------------------------------------------------------------------------------')
        print(' def add_mod( nsz=0, sf=0, tag='', unit='' ) ')
        print('-----------------------------------------------------------------------------------')
        print(' add 1 model to an existing SMDAT dictionary and returns updated SMDAT')
        print(' SF  (I): input SMDAT structure ')
        print(' TAG (I): tag of model to be added: "EMIS", "EXT", "POL" or "SDIST" ')
        print(' NSZ (I): int array(2) of sizes [nr of data pts, nr of grain types].')
        return 0

    if (sf == 0) or (tag==''):
        print('(F) ADD_MOD: sf or tag not specified')
        return -1
    if sf == -1: sf = { 'COM':'', 'NPAR':0, 'CHI2':0. }
    
    tag = tag.lower(); tag = tag.strip()
    if size(nsz) == 2:
        n1 = nsz[0]; n2 = nsz[1]
    else:
        print('(F) ADD_MOD: NSZ must be 2D')
        return -1

    i_emis = tag.find('emis')
    i_ext = tag.find('ext')
    i_sdist = tag.find('sdist')
    i_pol = tag.find('pol')
    if i_pol>-1: tag = tag.strip('pol')
    
    if i_emis != -1:
        if unit == '': unit='x(microns) SED(erg/s/cm2/sr)'
        s1 = {'UNIT': unit, \
              'X'   : double([0. for x in range(n1)]),                            # wave \
              'Y'   : double([[0.0 for x in range(n1)] for y in range(n2)])  }    # SED(wave, grain type) (index ntype is total)
        if i_pol>-1:
            s1['YP'] = double([[0.0 for x in range(n1)] for y in range(n2)])      # polarized SED(wave, grain type) (index ntype is total)
    elif i_ext != -1:     
        if unit == '': unit='x(microns) sigma(cm2/H)'      
        s1 = {'UNIT'   :   unit, \
              'X'      : double([0.0 for x in range(n1)]),                        # wave \
              'Y'      : double([[0.0 for x in range(n1)] for y in range(n2)]),   # sigma_ext(wave, grain type) (index ntype is total) \
              'ABS'    : double([[0.0 for x in range(n1)] for y in range(n2)]),   # sigma_abs(wave, grain type) \
              'SCA'    : double([[0.0 for x in range(n1)] for y in range(n2)]),   # sigma_abs(wave, grain type) \
              'ALB'    : double([[0.0 for x in range(n1)] for y in range(n2)])  } # albedo(wave, grain type)
        if i_pol>-1:
              ad = {'ABS_P': double([[0.0 for x in range(n1)] for y in range(n2)]),   # absorption sigma_pol(wave, grain type) \
                    'SCA_P': double([[0.0 for x in range(n1)] for y in range(n2)])  } # scattering sigma_pol(wave, grain type)
              s1.update(ad)
        ad = {'ALB'    : double([[0.0 for x in range(n1)] for y in range(n2)]),   # alb(wave, grain type) \
              'XR'     : double(0.0),                                             # ref wave \
              'YR_ABS' : double([0.0 for x in range(n2)]),                        # tau_abs/NH @ XR \
              'YR_SCA' : double([0.0 for x in range(n2)]),                        # tau_sca/NH @ XR \
              'RV'     : double(0.0)                                              }
        s1.update(ad)
    elif i_sdist != -1:
        if unit == '': unit='x(cm) a^4*dn/da(cm3/H)'     
        s1 = {'UNIT'  : unit, \
              'A'     : double([[0.0 for x in range(n1)] for y in range(n2)]),   # grain sizes per type (n3 = nsz_max) \
              'AVA'   : double([[0.0 for x in range(n1)] for y in range(n2)])  } # grain size dist per type
        if i_pol>-1:
            s1['AI'] = double([[0.0 for x in range(n1)] for y in range(n2)])    # alignment function size grid in microns
            s1['FI'] = double([[0.0 for x in range(n1)] for y in range(n2)])    # alignment function per type on size grid AI
    else:
        print('(F) ADD_MOD: no valid TAG name')
        return -1
    
    sm = sf
    tmp = {'M_'+tag.upper():s1}
    tmp.update(sm); sm = tmp  # add model key at begin of smdat
    
    return sm   # add_mod


def str_inst( n1=0, n2=0, photm=1, ntrans=0 ):

    from numpy import array,double
    
    if n1 == 0:
        print('-----------------------------------------------------------------------------------')
        print(' def str_inst( n1=0, n2=0, photm=1, ntrans=0 ):')
        print('-----------------------------------------------------------------------------------')
        print(' returns dictionary containing flux and color correction (CC) in band ')
        print(' N1     (I): number of data (or instrument) points')
        print(' N2     (I): nr of grain types or different models')
        print(' PHOTM  (I): 1 for an ensemble of photometric bands, 0 for continuous SED ')
        print(' NTRANS (I): nr of points in transmission to add band flux data, optional.')
        return 0

    if n2 == 0: n2 = 1

    if photm == 1: # flux in photometric band
        strct = { 'NAME' : ['' for x in range(n1)],                                 # name of inst bands \
                  'X'    : double([0.0 for x in range(n1)]),                        # band center in microns \
                  'YD'   : double([0.0 for x in range(n1)]),                        # data points (erg/s/cm2/sr) \
                  'ERR'  : double([0.0 for x in range(n1)]),                        # error on YD same unit \
                  'YM'   : double([[0.0 for x in range(n1)] for y in range(n2)]),   # SED of model in bands (erg/s/cm2/sr) (last value is the sum)\
                  'FLX'  : double([[0.0 for x in range(n1)] for y in range(n2)]),   # flux of model in bands (MJy/sr) \
                  'CC'   : double([[0.0 for x in range(n1)] for y in range(n2)]),   # color correction in band \        
                  'RR'   : double([0.0 for x in range(n1)]),                        # band sampling ratio flux/fil \                
                  'ISEL' : array([1 for x in range(n1)]),                           # mask for band selection, 0:discard band, 1=take band \
                  'UNIT' :  '',                                                     # info on units for X,YD,YM,FLX \
                  'NPAR' :  0,                                                      # \
                  'CHI2' :  double(0.0)                 }                           # chi-square on current bands masked with ISEL
# add transmission data
        s1 = {'X': double([[0.0 for x in range(n1)] for y in range(ntrans)]),  # X-grid for band transmission \
              'Y': double([[0.0 for x in range(n1)] for y in range(ntrans)]) } # band transmission
        strct['TRANS'] = s1     
    elif photm == 0: # continuous SED flux 
        strct = { 'NAME': '',   # name of SED spectrum data \
                  'X'    : double([0.0 for x in range(n1)]), \
                  'YD'   : double([0.0 for x in range(n1)]), \
                  'ERR'  : double([0.0 for x in range(n1)]), \
                  'YM'   : double([[0.0 for x in range(n1)] for y in range(n2)]), \
                  'ISEL' : array([1 for x in range(n1)]),    \
                  'UNIT' :  '', \
                  'NPAR' :  0, \
                  'CHI2' :  0.0                      }

    return strct  # str_inst


def chi2( y, model, npar, err=0 ):
# returns the chi-square value of fit MODEL to data Y
#
# NPAR (I): nr of parameters in the fit
# ERR  (I): error of each data point. Default is ERR=0.1*Y

  from numpy import size

  ny = size(y)
  if sum(err) == 0:
     err = 0.1*y
     print('(W) CHI2: error missing, set to 10 %')

  ndof = ny - npar              # nr of degrees of freedom
  chi = sum( ((y-model)/err)**2 )
  if ndof > 0: chi = chi / ndof

  return chi  # chi2


def fil_chi2( sf, npar=0 ):
# fills in the Chi-square fields of an input SMDAT structure 
# (see format in GET_BAND_FLUX)
#
# SF    (I): input SMDAT structure 

    from numpy import append,array,double,shape,size,where
    #from str_tools import chi2
    
# nr of parameters    
    ntype = sf['M_EMIS']['Y'].shape[0]  # gets nr of grain types or models
    if npar == 0: npar = ntype 
    sf['NPAR'] = npar
        
    stag = list(sf)
    itg = [i for i, s in enumerate(stag) if 'I_' in s]; ctg = size(itg) # finds indices of 'I_' in key list
    if ctg == 0:
        print('(F) FIL_CHI2: no instrument to fill in')
        return -1

    yy=double(0); mm=yy; ee=yy; ift=0
    for k in range(ctg):
        t1 = sf[stag[itg[k]]]['ISEL']; t2 = sf[stag[itg[k]]]['ERR']>0.
        i1 = [i for i,s in enumerate(t1) if (t1[i]==1)*(t2[i]>0.) ]; c1=size(i1)
        if c1 > 0:   # get chi2 for each selected band
            sf[stag[itg[k]]]['CHI2'] = chi2( sf[stag[itg[k]]]['YD'][i1], sf[stag[itg[k]]]['YM'][ntype-1,i1], \
                                                 sf[stag[itg[k]]]['NPAR'], err=sf[stag[itg[k]]]['ERR'][i1] ) 
        yy = append( yy, sf[stag[itg[k]]]['YD'] )
        ee = append( ee, sf[stag[itg[k]]]['ERR'] )
        mm = append( mm, sf[stag[itg[k]]]['YM'][ntype-1,:] )
        ift = append( ift, sf[stag[itg[k]]]['ISEL'] )

# total chi2 on all instruments        
    yy=yy[1:]; ee=ee[1:]; mm=mm[1:]; ift=ift[1:]
    it = [i for i,s in enumerate(ift) if ift[i]==1 and ee[i]>0. ]; ct=size(it)
    if ct > 0: sf['CHI2'] = chi2( yy[it], mm[it], sf['NPAR'], err=ee[it] )

    return sf  # fil_chi2


def add_inst( nsz=0, sf=0, tag='', photm=1, ntrans=0 ):

    if nsz == 0:
        print('-----------------------------------------------------------------------------------')
        print(' def ADD_INST( nsz=0, sf=0, tag="", photm=1, ntrans=0 ):')
        print('-----------------------------------------------------------------------------------')
        print(' add 1 instrument to an existing SMDAT dictionary and returns updated SMDAT')
        print(' or adds a new instrument to SMDAT structure ')
        print()
        print(' SF     (I): SMDAT input structure')
        print(' TAG    (I): name of instrument to add list in show_dustem')
        print(' NSZ    (I): array(2) of sizes [nr of data pts, nr of grain types or models] ')
        print(' PHOTM  (I): 1 for an ensemble of photometric bands, 0 for continuous SED ')
        print(' NTRANS (I): nr of points for transmission (band flux data)')
        return 0

    from numpy import array,size,where
    
    if (sf == 0) or (tag==''):
        print('(F) ADD_INST: sf or tag not specified')
        return -1
    if sf == -1: sf = { 'COM':'', 'NPAR':0, 'CHI2':0. }
    if size(nsz) == 2:
        nx = nsz[0]; ntype = nsz[1]
    else:
        print('(F) ADD_INST: nsz must be 2D')
        return -1
    
    sf = add_mod( nsz=[nx,ntype],sf=sf,tag='emis' )
    
    stag = array(list(sf))
    tag = tag.lower(); tag = tag.strip()
    itg = where( stag == tag )[0]; ctg = size(itg) 
                    
    if ctg == 0:
        tag = 'I_'+tag.upper()
        sf[tag] = str_inst( n1=nx,n2=ntype,photm=photm,ntrans=ntrans ) # add inst key at end of smdat
#        stag = array(list(sf))
#        sf[tag]['ISEL'] = array([1 for i in range(nx)])  # update selected band array
    else:
        print('(W) ADD_INST: INST already exists in structure')
        
    return sf  # add_inst
