def hfi_read_bandpass( version='v101', path_rimo='' ):

# RIMO only
  
    from astropy.io import fits
    from numpy import double,where
  
    version = version.lower()
  
# -- Definitions
    const = {'C':2.9979246e+08,'H':6.6260755e-34,'HBAR':1.0545727e-34,'Kb':1.3806580e-23,'TCMB':2.725e0 }
  
    n_detect = 52 # Planck HFI
    n_measurements = 17000

    tmp = double([0.0 for x in range(n_measurements)])
    bp_info = {0:{'NAME':'','FREQ':tmp,'TRANS':tmp}}
    for i in range(1,n_detect): bp_info.update({i:{'NAME':'','FREQ':tmp,'TRANS':tmp}})
                                                 
    if version == 'v101':
      rimo_fits = 'HFI-RIMO-20101025_2_55.fits'
      fitsshift = 2
    elif version == 'v201':
      rimo_fits = 'HFI-RIMO-20101025_2_57.fits'
      fitsshift = 3

    fits_rimo = fits.open( path_rimo+rimo_fits )
    hdr_rimo = fits_rimo[1].header
    if hdr_rimo[4] != 52:
        print(' (F) HFI_READ_BANDPASS: not an HFI RIMO file ')
        return -1
    bolo_id_tmp = [ '00_100-1a', '01_100-1b', '20_100-2a', '21_100-2b', '40_100-3a', '41_100-3b', \
                  '80_100-4a', '81_100-4b', '02_143-1a', '03_143-1b', '30_143-2a', '31_143-2b', \
                  '50_143-3a', '51_143-3b', '82_143-4a', '83_143-4b', '10_143-5',  '42_143-6',  \
                  '60_143-7',  '70_143-8',  '11_217-5a', '12_217-5b', '43_217-6a', '44_217-6b', \
                  '61_217-7a', '62_217-7b', '71_217-8a', '72_217-8b', '04_217-1',  '22_217-2',  \
                  '52_217-3',  '84_217-4',  '23_353-3a', '24_353-3b', '32_353-4a', '33_353-4b', \
                  '53_353-5a', '54_353-5b', '63_353-6a', '64_353-6b', '05_353-1',  '13_353-2',  \
                  '45_353-7',  '85_353-8',  '14_545-1',  '34_545-2',  '55_545-3',  '73_545-4',  \
                  '25_857-1',  '35_857-2',  '65_857-3',  '74_857-4' ]

# Joining the information of the bandpasses in the bp_info structure
    for i in range(n_detect):
        name_rimo_tmp = fits_rimo[fitsshift+i].header[14]; name_rimo_tmp = name_rimo_tmp[9:].lower()
        q_name = [k for k, s in enumerate(bolo_id_tmp) if name_rimo_tmp in s][0] # finds indices of name_rimo_tmp in bolo_id_tmp
        bp_info[i]['NAME'] = bolo_id_tmp[q_name]  # completing the name of the detector (e.g. 100-1a in the RIMO)
        bp_info[i]['FREQ']  = fits_rimo[fitsshift+i].data['WAVENUMBER'] * 1e2 * const['C'] # wave number given in cm^-1
        bp_info[i]['TRANS'] = fits_rimo[fitsshift+i].data['TRANSMISSION']  # values of the transmission (normalized later)
      
    fits_rimo.close()

    return bp_info


def get_hfibolo_list( dark=0, channel='', polar=0):

  from numpy import array,where

# same bolo list as in hfi_read_bandpass  
  boloname = array([ '00_100-1a', '01_100-1b', '20_100-2a', '21_100-2b', '40_100-3a', '41_100-3b', \
                  '80_100-4a', '81_100-4b', '02_143-1a', '03_143-1b', '30_143-2a', '31_143-2b', \
                  '50_143-3a', '51_143-3b', '82_143-4a', '83_143-4b', '10_143-5',  '42_143-6',  \
                  '60_143-7',  '70_143-8',  '11_217-5a', '12_217-5b', '43_217-6a', '44_217-6b', \
                  '61_217-7a', '62_217-7b', '71_217-8a', '72_217-8b', '04_217-1',  '22_217-2',  \
                  '52_217-3',  '84_217-4',  '23_353-3a', '24_353-3b', '32_353-4a', '33_353-4b', \
                  '53_353-5a', '54_353-5b', '63_353-6a', '64_353-6b', '05_353-1',  '13_353-2',  \
                  '45_353-7',  '85_353-8',  '14_545-1',  '34_545-2',  '55_545-3',  '73_545-4',  \
                  '25_857-1',  '35_857-2',  '65_857-3',  '74_857-4' ])

  darkname = ['15_Dark1','75_Dark2']

  listbolo = boloname
  
  if dark == 1: listbolo = listbolo + darkname
    
  if len(channel) > 0:
    if polar == 1:
        ix = [k for k, s in enumerate(boloname) if channel in s and ('a' in s or 'b' in s)]
    else: ix = [k for k, s in enumerate(boloname) if channel in s]

    listbolo = boloname[ix]

  return listbolo

